/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.INBTTagable;
import forestry.core.config.Defaults;
import forestry.core.utils.PlainInventory;
import forestry.core.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryAdapter
implements IInventory,
INBTTagable {
    private IInventory inventory = null;
    private int[][] slotMap;

    public InventoryAdapter(int size, String name) {
        this(size, name, 64);
    }

    public InventoryAdapter(int size, String name, int stackLimit) {
        this(new PlainInventory(size, name, stackLimit));
    }

    public InventoryAdapter(IInventory inventory) {
        this.inventory = inventory;
        this.configureSided();
    }

    public InventoryAdapter copy() {
        InventoryAdapter copy = new InventoryAdapter(this.inventory.func_70302_i_(), this.inventory.func_145825_b(), this.inventory.func_70297_j_());
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            copy.func_70299_a(i, this.inventory.func_70301_a(i).func_77946_l());
        }
        return copy;
    }

    public ItemStack[] getStacks() {
        ItemStack[] stacks = new ItemStack[this.inventory.func_70302_i_()];
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            stacks[i] = this.inventory.func_70301_a(i);
        }
        return stacks;
    }

    public ItemStack[] getStacks(int slot1, int length) {
        ItemStack[] result = new ItemStack[length];
        for (int i = slot1; i < slot1 + length; ++i) {
            result[i - slot1] = this.inventory.func_70301_a(i);
        }
        return result;
    }

    public boolean tryAddStacksCopy(ItemStack[] stacks, boolean all) {
        boolean addedAll = true;
        for (ItemStack stack : stacks) {
            if (stack == null || this.tryAddStack(stack.func_77946_l(), all)) continue;
            addedAll = false;
        }
        return addedAll;
    }

    public boolean tryAddStacks(ItemStack[] stacks, boolean all) {
        boolean addedAll = true;
        for (ItemStack stack : stacks) {
            if (stack == null || this.tryAddStack(stack, all)) continue;
            addedAll = false;
        }
        return addedAll;
    }

    public boolean tryAddStack(ItemStack stack, boolean all) {
        return this.tryAddStack(stack, 0, this.func_70302_i_(), all);
    }

    public boolean tryAddStack(ItemStack stack, int startSlot, int slots, boolean all) {
        return this.tryAddStack(stack, startSlot, slots, all, true);
    }

    public boolean tryAddStack(ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        return this.addStack(stack, startSlot, slots, all, doAdd) > 0;
    }

    public int addStack(ItemStack stack, boolean all, boolean doAdd) {
        return this.addStack(stack, 0, this.func_70302_i_(), all, doAdd);
    }

    public int addStack(ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        int i;
        int added = 0;
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (this.inventory.func_70301_a(i) == null || !this.inventory.func_70301_a(i).func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)this.inventory.func_70301_a(i), (ItemStack)stack)) continue;
            int remain = stack.field_77994_a - added;
            int space = this.inventory.func_70301_a(i).func_77976_d() - this.inventory.func_70301_a((int)i).field_77994_a;
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    this.inventory.func_70301_a((int)i).field_77994_a += remain;
                }
                return stack.field_77994_a;
            }
            if (doAdd) {
                this.inventory.func_70301_a((int)i).field_77994_a = this.inventory.func_70301_a(i).func_77976_d();
            }
            added += space;
        }
        if (added >= stack.field_77994_a) {
            return added;
        }
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (this.inventory.func_70301_a(i) != null) continue;
            if (doAdd) {
                this.func_70299_a(i, stack.func_77946_l());
                this.inventory.func_70301_a((int)i).field_77994_a = stack.field_77994_a - added;
            }
            return stack.field_77994_a;
        }
        return added;
    }

    public boolean contains(ItemStack[] query, int startSlot, int slots) {
        for (ItemStack queried : query) {
            int itemCount = 0;
            for (int i = startSlot; i < startSlot + slots; ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack == null) continue;
                if (StackUtils.equals(Blocks.field_150350_a, queried)) {
                    itemCount += stack.field_77994_a;
                    continue;
                }
                if (queried.func_77960_j() < 0) {
                    if (stack.func_77973_b() != queried.func_77973_b()) continue;
                    itemCount += stack.field_77994_a;
                    continue;
                }
                if (!stack.func_77969_a(queried) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)queried)) continue;
                itemCount += stack.field_77994_a;
            }
            if (itemCount >= queried.field_77994_a) continue;
            return false;
        }
        return true;
    }

    public void removeResources(ItemStack[] query, int startSlot, int slots) {
        block0: for (ItemStack queried : query) {
            ItemStack remain = queried.func_77946_l();
            for (int i = startSlot; i < startSlot + slots; ++i) {
                ItemStack removed;
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack == null) continue;
                if (queried.func_77960_j() < 0) {
                    if (stack.func_77973_b() == queried.func_77973_b()) {
                        removed = this.func_70298_a(i, remain.field_77994_a);
                        remain.field_77994_a -= removed.field_77994_a;
                    }
                } else if (stack.func_77969_a(remain) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)remain)) {
                    removed = this.func_70298_a(i, remain.field_77994_a);
                    remain.field_77994_a -= removed.field_77994_a;
                }
                if (remain.field_77994_a <= 0) continue block0;
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inventory.func_70298_a(slotId, count);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inventory.func_70299_a(slotId, itemstack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.inventory.func_70304_b(slotIndex);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] getSizeInventorySide(int side) {
        return this.slotMap[side];
    }

    private void configureSided() {
        this.slotMap = new int[6][0];
        this.configureSided(Defaults.FACINGS, 0, this.func_70302_i_());
    }

    public InventoryAdapter configureSidedUp(int startSlot, int count) {
        return this.configureSided(1, startSlot, count);
    }

    public InventoryAdapter configureSidedDown(int startSlot, int count) {
        return this.configureSided(0, startSlot, count);
    }

    public InventoryAdapter configureSidedNorthSouth(int startSlot, int count) {
        return this.configureSided(Defaults.FACING_NORTHSOUTH, startSlot, count);
    }

    public InventoryAdapter configureSidedWestEast(int startSlot, int count) {
        return this.configureSided(Defaults.FACING_WESTEAST, startSlot, count);
    }

    public InventoryAdapter configureSidedSides(int startSlot, int count) {
        return this.configureSided(Defaults.FACING_SIDES, startSlot, count);
    }

    public InventoryAdapter configureSided(int side, int startSlot, int count) {
        return this.configureSided(new int[]{side}, startSlot, count);
    }

    public InventoryAdapter configureSided(int[] sides, int startSlot, int count) {
        int[] slots = new int[count];
        for (int i = 0; i < count; ++i) {
            slots[i] = startSlot + i;
        }
        return this.configureSided(sides, slots);
    }

    public InventoryAdapter configureSided(int[] sides, int[] slots) {
        for (int side : sides) {
            this.slotMap[side] = slots;
        }
        return this;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.func_74764_b(this.inventory.func_145825_b())) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(this.inventory.func_145825_b(), 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            byte index = nbttagcompound2.func_74771_c("Slot");
            this.inventory.func_70299_a((int)index, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.func_74774_a("Slot", (byte)i);
            this.inventory.func_70301_a(i).func_77955_b(nbttagcompound2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
        }
        nbttagcompound.func_74782_a(this.inventory.func_145825_b(), (NBTBase)nbttaglist);
    }
}

