/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.proxy.Proxies;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

@Deprecated
public class Localization {
    public static Localization instance = new Localization();
    private static final String DEFAULT_LANGUAGE = "en_US";
    private String loadedLanguage = null;
    private Properties defaultMappings = new Properties();
    private Properties mappings = new Properties();
    private LinkedList<String> modules = new LinkedList();

    public Localization() {
        this.addLocalization("/lang/forestry/core/");
    }

    public void addLocalization(String path) {
        this.modules.add(path);
        this.load(path, DEFAULT_LANGUAGE);
    }

    private void load(String newLanguage) {
        this.defaultMappings.clear();
        this.mappings.clear();
        for (String path : this.modules) {
            this.load(path, newLanguage);
        }
    }

    private void load(String path, String newLanguage) {
        Properties modMappings = new Properties();
        try {
            InputStream langStream = Localization.class.getResourceAsStream(path + newLanguage + ".properties");
            InputStream defaultLangStream = Localization.class.getResourceAsStream(path + DEFAULT_LANGUAGE + ".properties");
            modMappings.load(langStream == null ? defaultLangStream : langStream);
            this.mappings.putAll((Map<?, ?>)modMappings);
            modMappings.clear();
            modMappings.load(defaultLangStream);
            this.defaultMappings.putAll((Map<?, ?>)modMappings);
            if (langStream != null) {
                langStream.close();
            }
            defaultLangStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadedLanguage = newLanguage;
    }

    public synchronized String get(String key) {
        String currentLanguage = Localization.getCurrentLanguage();
        if (currentLanguage == null || !currentLanguage.equals(this.loadedLanguage)) {
            this.load(currentLanguage);
        }
        return this.mappings.getProperty(key, this.defaultMappings.getProperty(key, key));
    }

    public boolean hasMapping(String key) {
        return this.mappings.containsKey(key) || this.defaultMappings.containsKey(key);
    }

    private static String getCurrentLanguage() {
        return Proxies.common.getCurrentLanguage();
    }
}

