/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import net.minecraft.item.ItemStack;

public class RecipeUtil {
    public static void injectLeveledRecipe(ItemStack resource, int fermentationValue, String output) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, LiquidHelper.getLiquid(output, 1), LiquidHelper.getLiquid("water", 1));
        if (LiquidHelper.exists("juice")) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, LiquidHelper.getLiquid(output, 1), LiquidHelper.getLiquid("juice", 1));
        }
        if (LiquidHelper.exists("honey")) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, LiquidHelper.getLiquid(output, 1), LiquidHelper.getLiquid("honey", 1));
        }
    }

    public static Object[] getCraftingRecipeAsArray(Object rec) {
        try {
            if (rec instanceof IDescriptiveRecipe) {
                IDescriptiveRecipe recipe = (IDescriptiveRecipe)rec;
                return RecipeUtil.getShapedRecipeAsArray(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients(), recipe.func_77571_b());
            }
        }
        catch (Exception ex) {
            Proxies.log.warning("Exception while trying to parse an ItemStack[10] from an IRecipe:");
            Proxies.log.warning(ex.getMessage());
        }
        return null;
    }

    private static Object[] getShapedRecipeAsArray(int width, int height, Object[] ingredients, ItemStack output) {
        Object[] result = new Object[10];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y * 3 + x] = ingredients[y * width + x];
            }
        }
        result[9] = output;
        return result;
    }
}

