/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import buildcraft.api.gates.ITrigger;
import cpw.mods.fml.common.registry.GameData;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpecialInventory;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.TileInventoryAdapter;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class EngineCopper
extends Engine
implements ISpecialInventory,
ISidedInventory {
    public static final short SLOT_FUEL = 0;
    public static final short SLOT_WASTE_1 = 1;
    public static final short SLOT_WASTE_COUNT = 4;
    private Item fuelItem;
    private int fuelItemMeta;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private final int ashForItem;
    private final TileInventoryAdapter inventory;

    public EngineCopper() {
        super(10000, 20000, 400);
        this.setHints(Config.hints.get("engine.copper"));
        this.ashForItem = 7500;
        this.inventory = new TileInventoryAdapter(this, 5, "Items");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineCopperGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private int getFuelSlot() {
        if (this.inventory.func_70301_a(0) == null) {
            return -1;
        }
        if (this.determineFuelValue(this.inventory.func_70301_a(0)) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        for (int i = 1; i <= 4; ++i) {
            if (this.inventory.func_70301_a(i) == null) {
                return i;
            }
            if (!ForestryItem.ash.isItemEqual(this.inventory.func_70301_a(i)) || this.inventory.func_70301_a((int)i).field_77994_a >= 64) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        if (this.mayBurn() && this.burnTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return;
        }
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot >= 0 && this.determineBurnDuration(this.inventory.func_70301_a(fuelSlot)) > 0) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NOFUEL);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.isActivated()) {
                this.currentOutput = this.determineFuelValue(new ItemStack(this.fuelItem, 1, this.fuelItemMeta));
                this.addEnergy(this.currentOutput);
            }
        } else if (this.isActivated()) {
            int fuelslot = this.getFuelSlot();
            int wasteslot = this.getFreeWasteSlot();
            if (fuelslot >= 0 && wasteslot >= 0) {
                this.burnTime = this.totalBurnTime = this.determineBurnDuration(this.inventory.func_70301_a(fuelslot));
                if (this.burnTime > 0) {
                    this.fuelItem = this.inventory.func_70301_a(fuelslot).func_77973_b();
                    this.func_70298_a(fuelslot, 1);
                }
            }
        }
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int heat = 0;
        if (this.isBurning()) {
            ++heat;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++heat;
            }
        }
        this.addHeat(heat);
        return heat;
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteslot = this.getFreeWasteSlot();
        if (wasteslot >= 0) {
            if (this.inventory.func_70301_a(wasteslot) == null) {
                this.inventory.func_70299_a(wasteslot, ForestryItem.ash.getItemStack());
            } else {
                ++this.inventory.func_70301_a((int)wasteslot).field_77994_a;
            }
        }
        this.ashProduction = 0;
        this.dumpStash();
    }

    private int determineFuelValue(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get((Object)fuel).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnDuration(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get((Object)fuel).burnDuration;
        }
        return 0;
    }

    private void dumpStash() {
        ForgeDirection[] pipes = BlockUtil.getPipeDirections(this.field_145850_b, this.Coords(), ForgeDirection.UNKNOWN);
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        }
    }

    private void dumpToPipe(ForgeDirection[] pipes) {
        for (int i = 1; i < 5; ++i) {
            if (this.inventory.func_70301_a(i) == null || this.inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
            ArrayList<ForgeDirection> filtered = BlockUtil.filterPipeDirections(pipes, new ForgeDirection[]{this.getOrientation()});
            while (this.inventory.func_70301_a((int)i).field_77994_a > 0 && filtered.size() > 0) {
                BlockUtil.putFromStackIntoPipe(this, filtered, this.inventory.func_70301_a(i));
            }
            if (this.inventory.func_70301_a((int)i).field_77994_a > 0) continue;
            this.inventory.func_70299_a(i, null);
        }
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        return (float)this.inventory.func_70301_a((int)fuelSlot).field_77994_a / (float)this.inventory.func_70301_a(fuelSlot).func_77976_d() > percentage;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        String fuelItemName = nbttagcompound.func_74779_i("EngineFuelItem");
        if (!fuelItemName.isEmpty()) {
            this.fuelItem = (Item)GameData.getItemRegistry().getRaw(fuelItemName);
        }
        this.fuelItemMeta = nbttagcompound.func_74762_e("EngineFuelMeta");
        this.burnTime = nbttagcompound.func_74762_e("EngineBurnTime");
        this.totalBurnTime = nbttagcompound.func_74762_e("EngineTotalTime");
        if (nbttagcompound.func_74764_b("AshProduction")) {
            this.ashProduction = nbttagcompound.func_74762_e("AshProduction");
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.fuelItem != null) {
            nbttagcompound.func_74778_a("EngineFuelItem", GameData.getItemRegistry().func_148750_c((Object)this.fuelItem));
        }
        nbttagcompound.func_74768_a("EngineFuelMeta", this.fuelItemMeta);
        nbttagcompound.func_74768_a("EngineBurnTime", this.burnTime);
        nbttagcompound.func_74768_a("EngineTotalTime", this.totalBurnTime);
        nbttagcompound.func_74768_a("AshProduction", this.ashProduction);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalBurnTime = j;
                break;
            }
            case 2: {
                this.currentOutput = j;
                break;
            }
            case 3: {
                this.storedEnergy = j;
                break;
            }
            case 4: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.burnTime);
        iCrafting.func_71112_a(containerEngine, 1, this.totalBurnTime);
        iCrafting.func_71112_a(containerEngine, 2, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 3, (int)this.storedEnergy);
        iCrafting.func_71112_a(containerEngine, 4, this.heat);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public String func_145825_b() {
        return "engine.1.name";
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex >= 1 && slotIndex < 5;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 0 && FuelManager.copperEngineFuel.containsKey(itemstack);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (FuelManager.copperEngineFuel.containsKey(stack)) {
            return this.inventory.addStack(stack, 0, 1, false, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        for (int i = 1; i < 5; ++i) {
            if (this.inventory.func_70301_a(i) == null || !ForestryItem.ash.isItemEqual(this.inventory.func_70301_a(i))) continue;
            ItemStack product = ForestryItem.ash.getItemStack();
            if (doRemove) {
                this.func_70298_a(i, 1);
            }
            return new ItemStack[]{product};
        }
        return new ItemStack[0];
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        LinkedList<ITrigger> res = new LinkedList<ITrigger>();
        res.add(ForestryTrigger.lowFuel25);
        return res;
    }
}

