/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.GuiId;
import forestry.core.utils.DelayTimer;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.InventoryAdapter;
import forestry.plugins.PluginIC2;
import ic2.api.energy.prefab.BasicSink;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EngineTin
extends Engine
implements ISocketable,
IInventory {
    private final short batterySlot = 0;
    private final InventoryAdapter inventory = new InventoryAdapter(1, "electrical");
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final EuConfig euConfig = new EuConfig(6, 2, 12);
    protected BasicSink ic2EnergySink;
    private final DelayTimer delayUpdateTimer = new DelayTimer();

    public EngineTin() {
        super(3000, 10000, 400);
        this.setHints(Config.hints.get("engine.tin"));
        if (PluginIC2.instance.isAvailable()) {
            this.ic2EnergySink = new BasicSink((TileEntity)this, this.euConfig.euStorage, 3);
        }
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineTinGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.func_145839_a(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.func_145839_a(nbttagcompound);
        }
        this.inventory.readFromNBT(nbttagcompound);
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.func_70301_a(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.func_145841_b(nbttagcompound);
        }
        this.inventory.writeToNBT(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
    }

    public void onChunkUnload() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.onChunkUnload();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.func_145843_s();
        }
        super.func_145843_s();
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning() || !this.isActivated()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int gain = 0;
        if (this.isActivated() && this.isBurning()) {
            ++gain;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++gain;
            }
        }
        this.addHeat(gain);
        return gain;
    }

    @Override
    public void updateServerSide() {
        if (this.ic2EnergySink == null) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        this.ic2EnergySink.func_145845_h();
        super.updateServerSide();
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        if (this.inventory.func_70301_a(0) != null) {
            this.replenishFromBattery(0);
        }
        if (!this.delayUpdateTimer.delayPassed(this.field_145850_b, 80L)) {
            return;
        }
        if (this.currentOutput <= 0 && this.getErrorState() == EnumErrorCode.OK) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (!this.isActivated()) {
            return;
        }
        if (this.ic2EnergySink.useEnergy((double)this.euConfig.euForCycle)) {
            this.currentOutput = this.euConfig.mjPerCycle;
            this.addEnergy(this.euConfig.mjPerCycle);
        }
    }

    private void replenishFromBattery(int slot) {
        if (!this.isActivated()) {
            return;
        }
        this.ic2EnergySink.discharge(this.inventory.func_70301_a(slot), this.euConfig.euForCycle * 3);
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.ic2EnergySink != null && this.ic2EnergySink.canUseEnergy((double)this.euConfig.euForCycle);
    }

    public int getStorageScaled(int i) {
        if (this.ic2EnergySink == null) {
            return 0;
        }
        return Math.min(i, (int)(this.ic2EnergySink.getEnergyStored() * (double)i) / this.ic2EnergySink.getCapacity());
    }

    public EnumTankLevel rateLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.currentOutput = j;
                break;
            }
            case 1: {
                this.storedEnergy = j;
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                if (this.ic2EnergySink == null) break;
                this.ic2EnergySink.setEnergyStored((double)j);
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 1, (int)this.storedEnergy);
        iCrafting.func_71112_a(containerEngine, 2, this.heat);
        if (this.ic2EnergySink != null) {
            iCrafting.func_71112_a(containerEngine, 3, (int)((short)this.ic2EnergySink.getEnergyStored()));
        }
    }

    public void changeEnergyConfig(int euChange, int mjChange, int storageChange) {
        this.euConfig.euForCycle += euChange;
        this.euConfig.mjPerCycle += mjChange;
        this.euConfig.euStorage += storageChange;
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.setCapacity(this.euConfig.euStorage);
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public String func_145825_b() {
        return "engine.0.name";
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.func_70301_a(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        if (stack == null) {
            this.sockets.func_70299_a(slot, stack);
            return;
        }
        this.sockets.func_70299_a(slot, stack);
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    protected static class EuConfig {
        public int euForCycle;
        public int mjPerCycle;
        public int euStorage;
        public int euMaxAccept = 512;

        public EuConfig(int euForCycle, int mjPerCycle, int euStorage) {
            this.euForCycle = euForCycle;
            this.mjPerCycle = mjPerCycle;
            this.euStorage = euStorage;
        }
    }
}

