/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpecialInventory;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.plugins.PluginIC2;
import ic2.api.energy.prefab.BasicSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineGenerator
extends TileBase
implements ISpecialInventory,
ILiquidTankContainer,
IRenderableMachine {
    public static final short SLOT_CAN = 0;
    public static final int maxEnergy = 30000;
    @EntityNetData
    public ForestryTank resourceTank = new ForestryTank(10000);
    private int tickCount = 0;
    InventoryAdapter inventory = new InventoryAdapter(1, "Items");
    protected BasicSource ic2EnergySource;

    public MachineGenerator() {
        this.setHints(Config.hints.get("generator"));
        if (PluginIC2.instance.isAvailable()) {
            this.ic2EnergySource = new BasicSource((TileEntity)this, 30000.0, 1);
        }
    }

    public String func_145825_b() {
        return "engine.3.name";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.GeneratorGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.func_145841_b(nbttagcompound);
        }
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.func_145839_a(nbttagcompound);
        }
        this.resourceTank = new ForestryTank(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    public void onChunkUnload() {
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.onChunkUnload();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.func_145843_s();
        }
        super.func_145843_s();
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        if (this.inventory.func_70301_a(0) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(0))) != null && GeneratorFuel.fuels.containsKey(container.fluid.fluidID)) {
            this.inventory.func_70299_a(0, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(0), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)0).field_77994_a <= 0) {
                this.inventory.func_70299_a(0, null);
            }
        }
        if (this.ic2EnergySource == null) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        this.ic2EnergySource.func_145845_h();
        if (this.resourceTank.getFluidAmount() > 0 && GeneratorFuel.fuels.containsKey(this.resourceTank.getFluid().fluidID)) {
            GeneratorFuel fuel = GeneratorFuel.fuels.get(this.resourceTank.getFluid().fluidID);
            if (this.resourceTank.getFluidAmount() >= fuel.fuelConsumed.amount && this.ic2EnergySource.getFreeCapacity() >= (double)fuel.eu) {
                this.ic2EnergySource.addEnergy((double)fuel.eu);
                ++this.tickCount;
                if (this.tickCount >= fuel.rate) {
                    this.tickCount = 0;
                    this.resourceTank.drain(fuel.fuelConsumed.amount, true);
                }
            }
        }
        if (this.resourceTank.getFluidAmount() <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    public boolean isWorking() {
        return this.resourceTank.getFluidAmount() > 0;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getStoredScaled(int i) {
        if (this.ic2EnergySource == null) {
            return 0;
        }
        return (int)(this.ic2EnergySource.getEnergyStored() * (double)i) / 30000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                if (this.ic2EnergySource == null) break;
                this.ic2EnergySource.setEnergyStored((double)j);
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.ic2EnergySource != null) {
            iCrafting.func_71112_a(container, 0, (int)((short)this.ic2EnergySource.getEnergyStored()));
        }
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container == null) {
            return 0;
        }
        if (!GeneratorFuel.fuels.containsKey(container.fluid.fluidID)) {
            return 0;
        }
        if (this.inventory.func_70301_a(0) == null) {
            if (doAdd) {
                this.inventory.func_70299_a(0, stack.func_77946_l());
            }
            return stack.field_77994_a;
        }
        if (!this.inventory.func_70301_a(0).func_77969_a(stack)) {
            return 0;
        }
        int space = this.inventory.func_70301_a(0).func_77976_d() - this.inventory.func_70301_a((int)0).field_77994_a;
        if (space <= 0) {
            return 0;
        }
        if (doAdd) {
            this.inventory.func_70301_a((int)0).field_77994_a += stack.field_77994_a;
        }
        return Math.min(space, stack.field_77994_a);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!GeneratorFuel.fuels.containsKey(resource.fluidID)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank};
    }
}

