/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.render;

import forestry.core.TemperatureState;
import forestry.core.gadgets.Engine;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryResource;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderEngine
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private final ModelBase model = new ModelBase(){};
    private final ModelRenderer boiler = new ModelRenderer(this.model, 0, 0);
    private final ModelRenderer trunk;
    private final ModelRenderer piston;
    private final ModelRenderer extension;
    private ResourceLocation[] textures;
    private static final float[] angleMap = new float[6];

    public RenderEngine() {
        this.boiler.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 6, 16);
        this.boiler.field_78800_c = 8.0f;
        this.boiler.field_78797_d = 8.0f;
        this.boiler.field_78798_e = 8.0f;
        this.trunk = new ModelRenderer(this.model, 0, 0);
        this.trunk.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.field_78800_c = 8.0f;
        this.trunk.field_78797_d = 8.0f;
        this.trunk.field_78798_e = 8.0f;
        this.piston = new ModelRenderer(this.model, 0, 0);
        this.piston.func_78789_a(-6.0f, -2.0f, -6.0f, 12, 4, 12);
        this.piston.field_78800_c = 8.0f;
        this.piston.field_78797_d = 8.0f;
        this.piston.field_78798_e = 8.0f;
        this.extension = new ModelRenderer(this.model, 0, 0);
        this.extension.func_78789_a(-5.0f, -3.0f, -5.0f, 10, 2, 10);
        this.extension.field_78800_c = 8.0f;
        this.extension.field_78797_d = 8.0f;
        this.extension.field_78798_e = 8.0f;
    }

    public RenderEngine(String baseTexture) {
        this();
        this.textures = new ResourceLocation[]{new ForestryResource(baseTexture + "base.png"), new ForestryResource(baseTexture + "piston.png"), new ForestryResource(baseTexture + "extension.png"), new ForestryResource("textures/blocks/engine_trunk_highest.png"), new ForestryResource("textures/blocks/engine_trunk_higher.png"), new ForestryResource("textures/blocks/engine_trunk_high.png"), new ForestryResource("textures/blocks/engine_trunk_medium.png"), new ForestryResource("textures/blocks/engine_trunk_low.png")};
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(TemperatureState.COOL, 0.25f, ForgeDirection.UP, x, y, z);
    }

    public void func_147500_a(TileEntity tile, double d, double d1, double d2, float f) {
        Engine engine = (Engine)tile;
        if (engine != null) {
            this.render(engine.getTemperatureState(), engine.progress, engine.getOrientation(), d, d1, d2);
        }
    }

    private void render(TemperatureState state, float progress, ForgeDirection orientation, double x, double y, double z) {
        ResourceLocation texture;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 5.99f - (progress - 0.5f) * 2.0f * 5.99f : progress * 2.0f * 5.99f;
        float tfactor = step / 16.0f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{orientation.offsetX, orientation.offsetY, orientation.offsetZ};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                angle[2] = angleMap[orientation.ordinal()];
                break;
            }
            default: {
                angle[0] = angleMap[orientation.ordinal()];
            }
        }
        this.boiler.field_78795_f = angle[0];
        this.boiler.field_78796_g = angle[1];
        this.boiler.field_78808_h = angle[2];
        this.trunk.field_78795_f = angle[0];
        this.trunk.field_78796_g = angle[1];
        this.trunk.field_78808_h = angle[2];
        this.piston.field_78795_f = angle[0];
        this.piston.field_78796_g = angle[1];
        this.piston.field_78808_h = angle[2];
        this.extension.field_78795_f = angle[0];
        this.extension.field_78796_g = angle[1];
        this.extension.field_78808_h = angle[2];
        float factor = 0.0625f;
        Proxies.common.bindTexture(this.textures[Textures.BASE.ordinal()]);
        this.boiler.func_78785_a(factor);
        Proxies.common.bindTexture(this.textures[Textures.PISTON.ordinal()]);
        GL11.glTranslatef((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.piston.func_78785_a(factor);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        switch (state) {
            case OVERHEATING: {
                texture = this.textures[Textures.TRUNK_HIGHEST.ordinal()];
                break;
            }
            case RUNNING_HOT: {
                texture = this.textures[Textures.TRUNK_HIGHER.ordinal()];
                break;
            }
            case OPERATING_TEMPERATURE: {
                texture = this.textures[Textures.TRUNK_HIGH.ordinal()];
                break;
            }
            case WARMED_UP: {
                texture = this.textures[Textures.TRUNK_MEDIUM.ordinal()];
                break;
            }
            default: {
                texture = this.textures[Textures.TRUNK_LOW.ordinal()];
            }
        }
        Proxies.common.bindTexture(texture);
        this.trunk.func_78785_a(factor);
        Proxies.common.bindTexture(this.textures[Textures.EXTENSION.ordinal()]);
        float chamberf = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.extension.func_78785_a(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        RenderEngine.angleMap[ForgeDirection.EAST.ordinal()] = -1.5707964f;
        RenderEngine.angleMap[ForgeDirection.WEST.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.UP.ordinal()] = 0.0f;
        RenderEngine.angleMap[ForgeDirection.DOWN.ordinal()] = (float)Math.PI;
        RenderEngine.angleMap[ForgeDirection.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.NORTH.ordinal()] = -1.5707964f;
    }

    private static enum Textures {
        BASE,
        PISTON,
        EXTENSION,
        TRUNK_HIGHEST,
        TRUNK_HIGHER,
        TRUNK_HIGH,
        TRUNK_MEDIUM,
        TRUNK_LOW;

    }
}

