/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.PowerHandler;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineFermenter
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;
    @EntityNetData
    public ForestryTank resourceTank = new ForestryTank(10000);
    @EntityNetData
    public ForestryTank productTank = new ForestryTank(10000);
    private final InventoryAdapter inventory = new InventoryAdapter(5, "Items");
    private Recipe currentRecipe;
    private float currentResourceModifier;
    public int fermentationTime = 0;
    public int fermentationTotalTime = 0;
    public int fuelBurnTime = 0;
    public int fuelTotalTime = 0;
    public int fuelCurrentFerment = 0;

    public MachineFermenter() {
        this.setHints(Config.hints.get("fermenter"));
    }

    public String func_145825_b() {
        return "factory.3.name";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.FermenterGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    protected void configurePowerProvider(PowerHandler provider) {
        provider.configure(5.0, 200.0, 15.0, 800.0);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("FermentationTime", this.fermentationTime);
        nbttagcompound.func_74768_a("FermentationTotalTime", this.fermentationTotalTime);
        nbttagcompound.func_74768_a("FuelBurnTime", this.fuelBurnTime);
        nbttagcompound.func_74768_a("FuelTotalTime", this.fuelTotalTime);
        nbttagcompound.func_74768_a("FuelCurrentFerment", this.fuelCurrentFerment);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        NBTTagCompound NBTproductSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        nbttagcompound.func_74782_a("ProductTank", (NBTBase)NBTproductSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fermentationTime = nbttagcompound.func_74762_e("FermentationTime");
        this.fermentationTotalTime = nbttagcompound.func_74762_e("FermentationTotalTime");
        this.fuelBurnTime = nbttagcompound.func_74762_e("FuelBurnTime");
        this.fuelTotalTime = nbttagcompound.func_74762_e("FuelTotalTime");
        this.fuelCurrentFerment = nbttagcompound.func_74762_e("FuelCurrentFerment");
        this.resourceTank = new ForestryTank(10000);
        this.productTank = new ForestryTank(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
            this.productTank.readFromNBT(nbttagcompound.func_74775_l("ProductTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        if (this.inventory.func_70301_a(4) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(4))) != null && RecipeManager.isLiquidResource(container.fluid)) {
            this.inventory.func_70299_a(4, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(4), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)4).field_77994_a <= 0) {
                this.inventory.func_70299_a(4, null);
            }
        }
        if (this.inventory.func_70301_a(3) != null && (container = LiquidHelper.getEmptyContainer(this.inventory.func_70301_a(3), this.productTank.getFluid())) != null) {
            this.inventory.func_70299_a(2, this.bottleIntoContainer(this.inventory.func_70301_a(3), this.inventory.func_70301_a(2), container, this.productTank));
            if (this.inventory.func_70301_a((int)3).field_77994_a <= 0) {
                this.inventory.func_70299_a(3, null);
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        if (RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), this.resourceTank.getFluid()) != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else if (this.inventory.func_70301_a(1) == null && this.fuelBurnTime <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    @Override
    public boolean workCycle() {
        if (this.currentRecipe == null) {
            this.checkRecipe();
            this.resetRecipe();
            if (this.currentRecipe != null) {
                this.currentResourceModifier = this.determineResourceMod(this.inventory.func_70301_a(0));
                this.func_70298_a(0, 1);
                return true;
            }
            return false;
        }
        if (this.fuelBurnTime > 0) {
            if (this.currentRecipe == null) {
                throw new NullPointerException("currentRecipe is null");
            }
            if (this.resourceTank.getFluidAmount() < this.fuelCurrentFerment) {
                return false;
            }
            if (this.fermentationTime <= 0) {
                return false;
            }
            int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
            if (!this.addProduct(new FluidStack(this.currentRecipe.output, Math.round((float)fermented * this.currentRecipe.modifier * this.currentResourceModifier)))) {
                return false;
            }
            --this.fuelBurnTime;
            this.resourceTank.drain(this.fuelCurrentFerment, true);
            this.fermentationTime -= this.fuelCurrentFerment;
            if (this.fermentationTime > 0) {
                return true;
            }
            this.currentRecipe = null;
            return true;
        }
        this.fuelBurnTime = this.fuelTotalTime = this.determineFuelValue(this.getFuelStack());
        if (this.fuelBurnTime > 0) {
            this.fuelCurrentFerment = this.determineFermentPerCycle(this.getFuelStack());
            this.func_70298_a(1, 1);
            return true;
        }
        this.fuelCurrentFerment = 0;
        return false;
    }

    private boolean addProduct(FluidStack output) {
        int amount = this.productTank.fill(output, false);
        if (amount == output.amount) {
            this.productTank.fill(output, true);
            return true;
        }
        return false;
    }

    private void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), this.resourceTank.getFluid());
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fermentationTime = 0;
            this.fermentationTotalTime = 0;
            return;
        }
        this.fermentationTime = this.currentRecipe.fermentationValue;
        this.fermentationTotalTime = this.currentRecipe.fermentationValue;
    }

    private int determineFuelValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item)) {
            return FuelManager.fermenterFuel.get((Object)item).burnDuration;
        }
        return 0;
    }

    private int determineFermentPerCycle(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item)) {
            return FuelManager.fermenterFuel.get((Object)item).fermentPerCycle;
        }
        return 0;
    }

    private float determineResourceMod(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof IVariableFermentable)) {
            return 1.0f;
        }
        return ((IVariableFermentable)itemstack.func_77973_b()).getFermentationModifier(itemstack);
    }

    @Override
    public boolean isWorking() {
        if (this.currentRecipe == null && RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), this.resourceTank.getFluid()) == null) {
            return false;
        }
        if (this.fuelBurnTime > 0) {
            return this.resourceTank.getFluidAmount() > 0 && this.productTank.getFluidAmount() < 10000;
        }
        return this.determineFuelValue(this.getFuelStack()) > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.getFermentationStack() == null) {
            return false;
        }
        return (float)this.getFermentationStack().field_77994_a / (float)this.getFermentationStack().func_77976_d() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        if (this.getFuelStack() == null) {
            return false;
        }
        return (float)this.getFuelStack().field_77994_a / (float)this.getFuelStack().func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (this.getFuelStack() == null && this.fuelBurnTime <= 0) {
            return false;
        }
        if (this.fuelBurnTime <= 0 && RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), this.resourceTank.getFluid()) == null) {
            return false;
        }
        if (this.getFermentationStack() == null && this.fermentationTime <= 0) {
            return false;
        }
        if (this.fermentationTime <= 0 && RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), this.resourceTank.getFluid()) == null) {
            return false;
        }
        if (this.resourceTank.getFluidAmount() <= 0) {
            return false;
        }
        return this.productTank.getFluidAmount() < this.productTank.getCapacity();
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    public ItemStack getFermentationStack() {
        return this.inventory.func_70301_a(0);
    }

    public ItemStack getFuelStack() {
        return this.inventory.func_70301_a(1);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fuelBurnTime = j;
                break;
            }
            case 1: {
                this.fuelTotalTime = j;
                break;
            }
            case 2: {
                this.fermentationTime = j;
                break;
            }
            case 3: {
                this.fermentationTotalTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fuelBurnTime);
        iCrafting.func_71112_a(container, 1, this.fuelTotalTime);
        iCrafting.func_71112_a(container, 2, this.fermentationTime);
        iCrafting.func_71112_a(container, 3, this.fermentationTotalTime);
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 2;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 0 && RecipeManager.isResource(itemstack)) {
            return true;
        }
        if (slotIndex == 4) {
            FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(itemstack);
            return container != null && RecipeManager.isLiquidResource(container.fluid);
        }
        if (slotIndex == 3 && LiquidHelper.isEmptyContainer(itemstack)) {
            return true;
        }
        return slotIndex == 1 && FuelManager.fermenterFuel.containsKey(itemstack);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!RecipeManager.isLiquidResource(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.productTank.drain(quantityMax, doEmpty);
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank, this.productTank};
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        LinkedList<ITrigger> res = new LinkedList<ITrigger>();
        res.add(ForestryTrigger.lowFuel25);
        res.add(ForestryTrigger.lowFuel10);
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements IFermenterManager {
        public static ArrayList<Recipe> recipes = new ArrayList();

        @Override
        public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, liquid));
        }

        @Override
        public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output) {
            this.addRecipe(resource, fermentationValue, modifier, output, LiquidHelper.getLiquid("water", 1000));
        }

        public static Recipe findMatchingRecipe(ItemStack res, FluidStack liqu) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = recipes.get(i);
                if (!recipe.matches(res, liqu)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResource(ItemStack resource) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = recipes.get(i);
                if (recipe.resource.func_77960_j() == Short.MAX_VALUE && recipe.resource.func_77973_b() == resource.func_77973_b()) {
                    return true;
                }
                if (!recipe.resource.func_77969_a(resource)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidResource(FluidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = recipes.get(i);
                if (!recipe.liquid.isFluidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidProduct(FluidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = recipes.get(i);
                if (!recipe.output.isFluidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new Object[]{recipe.resource, recipe.liquid}, new Object[]{recipe.output});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final ItemStack resource;
        public final int fermentationValue;
        public final float modifier;
        public final FluidStack output;
        public final FluidStack liquid;

        public Recipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
            this.resource = resource;
            this.fermentationValue = fermentationValue;
            this.modifier = modifier;
            this.output = output;
            this.liquid = liquid;
            if (resource == null) {
                throw new NullPointerException("Fermenter Resource cannot be null!");
            }
            if (output == null) {
                throw new NullPointerException("Fermenter Output cannot be null!");
            }
            if (liquid == null) {
                throw new NullPointerException("Fermenter Liquid cannot be null!");
            }
        }

        public boolean matches(ItemStack res, FluidStack liqu) {
            if (res == null) {
                return false;
            }
            if (this.resource.func_77973_b() != res.func_77973_b()) {
                return false;
            }
            if (this.resource.func_77960_j() != Short.MAX_VALUE && this.resource.func_77960_j() != res.func_77960_j()) {
                return false;
            }
            if (this.liquid == null) {
                return true;
            }
            if (this.liquid != null && liqu == null) {
                return false;
            }
            if (!this.liquid.isFluidEqual(liqu)) {
                return false;
            }
            return this.liquid.amount <= liqu.amount;
        }
    }
}

