/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.gates.ITrigger;
import forestry.api.core.EnumHumidity;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.utils.Fluids;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MachineRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    private static final FluidStack STACK_WATER = LiquidHelper.getLiquid("water", 10);
    public ForestryTank resourceTank = new ForestryTank(30000);
    private final InventoryAdapter inventory = new InventoryAdapter(3, "Items");
    private boolean isValidBiome = true;
    private int fillingTime;
    private ItemStack usedEmpty;

    public MachineRaintank() {
        this.setHints(Config.hints.get("raintank"));
        if (this.field_145850_b != null) {
            BiomeGenBase biome = Utils.getBiomeAt(this.field_145850_b, this.field_145851_c, this.field_145849_e);
            if (EnumHumidity.getFromValue(biome.field_76751_G) == EnumHumidity.ARID) {
                this.setErrorState(EnumErrorCode.INVALIDBIOME);
                this.isValidBiome = false;
            }
        }
    }

    public String func_145825_b() {
        return "factory2.1.name";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsValidBiome", this.isValidBiome);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.isValidBiome = nbttagcompound.func_74767_n("IsValidBiome");
        this.resourceTank = new ForestryTank(30000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        if (!this.isValidBiome) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
        } else if (!this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            this.setErrorState(EnumErrorCode.NOSKY);
        } else if (!this.field_145850_b.func_72896_J()) {
            this.setErrorState(EnumErrorCode.NOTRAINING);
        } else {
            this.resourceTank.fill(STACK_WATER, true);
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.field_145850_b.func_82737_E() % 16L != 0L) {
            return;
        }
        if (!StackUtils.isIdenticalItem(this.usedEmpty, this.inventory.func_70301_a(0))) {
            this.fillingTime = 0;
            this.usedEmpty = null;
        }
        if (this.usedEmpty == null) {
            this.usedEmpty = this.inventory.func_70301_a(0);
        }
        if (!this.isFilling()) {
            this.tryToStartFillling();
        } else {
            --this.fillingTime;
            if (this.fillingTime <= 0 && LiquidHelper.fillContainers(this, this.inventory, 0, 1, Fluids.WATER.get())) {
                this.fillingTime = 0;
            }
        }
    }

    public boolean isFilling() {
        return this.fillingTime > 0;
    }

    private void tryToStartFillling() {
        if (!LiquidHelper.fillContainers(this, this.inventory, 0, 1, Fluids.WATER.get(), false)) {
            return;
        }
        this.fillingTime = 12;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingTime * i / 12;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 1;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex != 0) {
            return false;
        }
        return LiquidHelper.getEmptyContainer(itemstack, STACK_WATER) != null;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fillingTime);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!resource.isFluidEqual(STACK_WATER)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.resourceTank.drain(quantityMax, doEmpty);
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank};
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        LinkedList<ITrigger> res = new LinkedList<ITrigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }
}

