/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.Vect;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FarmLogic
implements IFarmLogic {
    World world;
    IFarmHousing housing;
    boolean isManual;

    public FarmLogic(IFarmHousing housing) {
        this.housing = housing;
    }

    public FarmLogic setManual(boolean flag) {
        this.isManual = flag;
        return this;
    }

    @Override
    public ResourceLocation getSpriteSheet() {
        return SpriteSheet.ITEMS.getLocation();
    }

    protected final boolean isAirBlock(Vect position) {
        return this.world.func_147437_c(position.x, position.y, position.z);
    }

    protected final boolean isWaterBlock(Vect position) {
        return this.world.func_147439_a(position.x, position.y, position.z) == Blocks.field_150355_j;
    }

    protected final boolean isWoodBlock(Vect position) {
        Block block = this.getBlock(position);
        return block.isWood((IBlockAccess)this.world, position.x, position.y, position.z);
    }

    protected final Block getBlock(Vect position) {
        return this.world.func_147439_a(position.x, position.y, position.z);
    }

    protected final int getBlockMeta(Vect position) {
        return this.world.func_72805_g(position.x, position.y, position.z);
    }

    protected final ItemStack getAsItemStack(Vect position) {
        return new ItemStack(this.getBlock(position), 1, this.getBlockMeta(position));
    }

    protected final Vect translateWithOffset(int x, int y, int z, ForgeDirection direction, int step) {
        return new Vect(x + direction.offsetX * step, y + direction.offsetY * step, z + direction.offsetZ * step);
    }

    protected final void setBlock(Vect position, Block block, int meta) {
        this.world.func_147465_d(position.x, position.y, position.z, block, meta, 2);
    }
}

