/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.config.ForestryBlock;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogicHomogenous;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmLogicArboreal
extends FarmLogicHomogenous {
    private final HashMap<Vect, Integer> lastExtentsHarvest = new HashMap();
    protected int yOffset = 0;

    public FarmLogicArboreal(IFarmHousing housing, ItemStack[] resource, ItemStack[] ground, ItemStack[] waste, IFarmable[] germlings) {
        super(housing, resource, ground, waste, germlings);
    }

    public FarmLogicArboreal(IFarmHousing housing) {
        super(housing, new ItemStack[]{new ItemStack(Blocks.field_150346_d)}, new ItemStack[]{ForestryBlock.soil.getItemStack(), ForestryBlock.soil.getItemStack(1, Short.MAX_VALUE)}, new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m)}, Farmables.farmables.get("farmArboreal").toArray(new IFarmable[0]));
    }

    @Override
    public String getName() {
        return "Managed Arboretum";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150345_g.func_149733_h(0);
    }

    @Override
    public ResourceLocation getSpriteSheet() {
        return SpriteSheet.BLOCKS.getLocation();
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(10.0f * hydrationModifier);
    }

    @Override
    public Collection<ItemStack> collect() {
        ArrayList products = this.produce;
        this.produce = new ArrayList();
        Vect coords = new Vect(this.housing.getCoords());
        Vect area = new Vect(this.housing.getArea());
        Vect offset = new Vect(this.housing.getOffset());
        Vect min = coords.add(offset);
        Vect max = coords.add(offset).add(area);
        AxisAlignedBB harvestBox = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.housing.getWorld().func_72872_a(Entity.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack contained;
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityItem)) continue;
            EntityItem item = (EntityItem)entity;
            if (item.field_70128_L || !this.isAcceptedGermling(contained = item.func_92059_d()) && !this.isWindfall(contained)) continue;
            this.produce.add(contained.func_77946_l());
            item.func_70106_y();
        }
        return products;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        int lastExtent;
        this.world = this.housing.getWorld();
        Collection<ICrop> crops = null;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtentsHarvest.containsKey(start)) {
            this.lastExtentsHarvest.put(start, 0);
        }
        if ((lastExtent = this.lastExtentsHarvest.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        crops = this.getHarvestBlocks(position);
        this.lastExtentsHarvest.put(start, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        ArrayList<Vect> seen = new ArrayList<Vect>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IFarmable germling = null;
        for (IFarmable germl : this.germlings) {
            ICrop crop = germl.getCropAt(this.world, position.x, position.y, position.z);
            if (crop == null) continue;
            crops.push(crop);
            seen.add(position);
            germling = germl;
            break;
        }
        if (germling == null) {
            return crops;
        }
        ArrayList<Vect> candidates = this.processHarvestBlock(germling, crops, seen, position, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty()) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(germling, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList<Vect> processHarvestBlock(IFarmable germling, Stack<ICrop> crops, Collection<Vect> seen, Vect start, Vect position) {
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int i = -1; i < 2; ++i) {
            for (int j = this.yOffset; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    ICrop crop;
                    Vect candidate = new Vect(position.x + i, position.y + j, position.z + k);
                    if (candidate.equals(position) || Math.abs(candidate.x - start.x) > 5 || Math.abs(candidate.z - start.z) > 5) continue;
                    boolean skip = false;
                    for (Vect prcs : seen) {
                        if (!candidate.equals(prcs)) continue;
                        skip = true;
                        break;
                    }
                    if (skip || (crop = germling.getCropAt(this.world, candidate.x, candidate.y, candidate.z)) == null) continue;
                    crops.push(crop);
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }

    @Override
    protected boolean maintainGermlings(int x, int ySaplings, int z, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, ySaplings, z, direction, i);
            if (!this.isAirBlock(position)) continue;
            Vect soilBelow = new Vect(position.x, position.y - 1, position.z);
            for (ItemStack grnd : this.ground) {
                if (!StackUtils.isIdenticalItem(grnd, this.getAsItemStack(soilBelow))) continue;
                return this.plantSapling(position);
            }
        }
        return false;
    }

    private boolean plantSapling(Vect position) {
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, this.world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }
}

