/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.genetics.IFruitBearer;
import forestry.core.config.ForestryItem;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropFruit;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmLogicOrchard
extends FarmLogic {
    private final HashMap<Vect, Integer> lastExtents = new HashMap();

    public FarmLogicOrchard(IFarmHousing housing) {
        super(housing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return ForestryItem.fruits.item().func_77617_a(0);
    }

    @Override
    public String getName() {
        return "Orchard";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        int lastExtent;
        this.world = this.housing.getWorld();
        Collection<ICrop> crops = null;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtents.containsKey(start)) {
            this.lastExtents.put(start, 0);
        }
        if ((lastExtent = this.lastExtents.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        crops = this.getHarvestBlocks(position);
        this.lastExtents.put(start, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        ArrayList<Vect> seen = new ArrayList<Vect>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IFruitBearer bearer = this.getFruitBlock(position);
        Block block = this.getBlock(position);
        if (!block.isWood((IBlockAccess)this.world, position.x, position.y, position.z) && bearer == null) {
            return crops;
        }
        ArrayList<Vect> candidates = this.processHarvestBlock(crops, seen, position, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList<Vect> processHarvestBlock(Stack<ICrop> crops, Collection<Vect> seen, Vect start, Vect position) {
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    Vect candidate = new Vect(position.x + i, position.y + j, position.z + k);
                    if (candidate.equals(position) || Math.abs(candidate.x - start.x) > 5 || Math.abs(candidate.z - start.z) > 5) continue;
                    boolean skip = false;
                    for (Vect prcs : seen) {
                        if (!candidate.equals(prcs)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    IFruitBearer bearer = this.getFruitBlock(candidate);
                    if (bearer != null && bearer.hasFruit()) {
                        if (bearer.getRipeness() >= 0.9f) {
                            crops.push(new CropFruit(this.world, candidate, bearer.getFruitFamily()));
                        }
                        candidates.add(candidate);
                        seen.add(candidate);
                        continue;
                    }
                    if (!this.isWoodBlock(candidate)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }

    private IFruitBearer getFruitBlock(Vect position) {
        TileEntity tile = this.world.func_147438_o(position.x, position.y, position.z);
        if (!(tile instanceof IFruitBearer)) {
            return null;
        }
        return (IFruitBearer)tile;
    }
}

