/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropRubber;
import forestry.farming.logic.FarmLogic;
import forestry.plugins.PluginIC2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmLogicRubber
extends FarmLogic {
    private boolean inActive;
    private final HashMap<Vect, Integer> lastExtents = new HashMap();

    public FarmLogicRubber(IFarmHousing housing) {
        super(housing);
        if (PluginIC2.rubberwood == null || PluginIC2.resin == null) {
            Proxies.log.warning("Failed to init a farm logic %s since IC2 was not found", (Object)this.getClass().getName());
            this.inActive = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        if (!this.inActive) {
            return PluginIC2.resin.func_77954_c();
        }
        return Items.field_151016_H.func_77617_a(0);
    }

    @Override
    public String getName() {
        return "Rubber Plantation";
    }

    @Override
    public int getFertilizerConsumption() {
        return 40;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(5.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        int lastExtent;
        if (this.inActive) {
            return null;
        }
        this.world = this.housing.getWorld();
        Collection<ICrop> crops = null;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtents.containsKey(start)) {
            this.lastExtents.put(start, 0);
        }
        if ((lastExtent = this.lastExtents.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        crops = this.getHarvestBlocks(position);
        this.lastExtents.put(start, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        ArrayList<Vect> seen = new ArrayList<Vect>();
        Stack<ICrop> crops = new Stack<ICrop>();
        Block block = this.getBlock(position);
        if (!StackUtils.equals(block, PluginIC2.rubberwood)) {
            return crops;
        }
        int meta = this.getBlockMeta(position);
        if (meta >= 2 && meta <= 5) {
            crops.push(new CropRubber(this.world, block, meta, position));
        }
        ArrayList<Vect> candidates = this.processHarvestBlock(crops, seen, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty() && crops.size() < 100) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList<Vect> processHarvestBlock(Stack<ICrop> crops, Collection<Vect> seen, Vect position) {
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int j = 0; j < 2; ++j) {
            Block block;
            Vect candidate = new Vect(position.x, position.y + j, position.z);
            if (candidate.equals(position)) continue;
            boolean skip = false;
            for (Vect prcs : seen) {
                if (!candidate.equals(prcs)) continue;
                skip = true;
                break;
            }
            if (skip || !StackUtils.equals(block = this.getBlock(candidate), PluginIC2.rubberwood)) continue;
            int meta = this.getBlockMeta(candidate);
            if (meta >= 2 && meta <= 5) {
                crops.push(new CropRubber(this.world, block, meta, candidate));
            }
            candidates.add(candidate);
            seen.add(candidate);
        }
        return candidates;
    }
}

