/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class FarmLogicWatered
extends FarmLogic {
    protected ItemStack[] ground;
    private final ItemStack[] resource;
    private final ItemStack[] waste;
    private static final FluidStack STACK_WATER = new FluidStack(LiquidHelper.getFluid("water"), 1000);
    ArrayList<ItemStack> produce = new ArrayList();

    public FarmLogicWatered(IFarmHousing housing, ItemStack[] resource, ItemStack[] ground, ItemStack[] waste) {
        super(housing);
        this.ground = ground;
        this.resource = resource;
        this.waste = waste;
    }

    @Override
    public int getFertilizerConsumption() {
        return 5;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource[0].func_77969_a(itemstack);
    }

    @Override
    public Collection<ItemStack> collect() {
        ArrayList<ItemStack> products = this.produce;
        this.produce = new ArrayList();
        return products;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        if (this.maintainSoil(x, y, z, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(x, y, z, direction, extent)) {
            return true;
        }
        return this.maintainCrops(x, y + 1, z, direction, extent);
    }

    private boolean isWaste(ItemStack stack) {
        for (ItemStack block : this.waste) {
            if (!block.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean maintainSoil(int x, int y, int z, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) {
                ItemStack block = this.getAsItemStack(position);
                if (!this.isWaste(block) || !this.housing.hasResources(this.resource)) continue;
                this.produce.addAll(StackUtils.getBlock(block).getDrops(this.world, x, y, z, block.func_77960_j(), 0));
                this.setBlock(position, Blocks.field_150350_a, 0);
                return this.trySetSoil(position);
            }
            if (this.isManual || this.isWaterBlock(position)) continue;
            if (i % 2 != 0) {
                ForgeDirection cclock = ForgeDirection.EAST;
                if (direction == ForgeDirection.EAST) {
                    cclock = ForgeDirection.SOUTH;
                } else if (direction == ForgeDirection.SOUTH) {
                    cclock = ForgeDirection.EAST;
                } else if (direction == ForgeDirection.WEST) {
                    cclock = ForgeDirection.SOUTH;
                }
                Vect previous = this.translateWithOffset(position.x, position.y, position.z, cclock, 1);
                ItemStack soil = this.getAsItemStack(previous);
                if (this.ground[0].func_77969_a(soil)) continue;
                this.trySetSoil(position);
                continue;
            }
            return this.trySetSoil(position);
        }
        return false;
    }

    private boolean maintainWater(int x, int y, int z, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z) || this.isWaterBlock(position)) continue;
            boolean isEnclosed = true;
            if (this.world.func_147437_c(position.x + 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x - 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x, position.y, position.z + 1)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x, position.y, position.z - 1)) {
                isEnclosed = false;
            }
            if (!isEnclosed) continue;
            return this.trySetWater(position);
        }
        return false;
    }

    protected boolean maintainCrops(int x, int y, int z, ForgeDirection direction, int extent) {
        return false;
    }

    private boolean trySetSoil(Vect position) {
        if (!this.housing.hasResources(this.resource)) {
            return false;
        }
        this.setBlock(position, StackUtils.getBlock(this.ground[0]), this.ground[0].func_77960_j());
        this.housing.removeResources(this.resource);
        return true;
    }

    private boolean trySetWater(Vect position) {
        System.out.println("trySetWater: at " + position.toString());
        if (!this.housing.hasLiquid(STACK_WATER)) {
            return false;
        }
        System.out.println("Can place water: at " + position.toString());
        this.setBlock(position, Blocks.field_150355_j, 0);
        this.housing.removeLiquid(STACK_WATER);
        return true;
    }
}

