/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableGenericCrop
implements IFarmable {
    private final ItemStack seed;
    private final Block block;
    private final int mature;

    public FarmableGenericCrop(ItemStack seed, Block block, int mature) {
        this.seed = seed;
        this.block = block;
        this.mature = mature;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        return world.func_147439_a(x, y, z) == this.block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this.block) {
            return null;
        }
        if (world.func_72805_g(x, y, z) != this.mature) {
            return null;
        }
        return new CropBlock(world, this.block, this.mature, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (this.seed.func_77973_b() != itemstack.func_77973_b()) {
            return false;
        }
        if (this.seed.func_77960_j() >= 0) {
            return this.seed.func_77960_j() == itemstack.func_77960_j();
        }
        return true;
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return germling.func_77946_l().func_77943_a(Utils.getForestryPlayer(world, x, y, z), world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

