/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerLowFertilizer
extends Trigger {
    private final float threshold;

    public TriggerLowFertilizer(String tag, float threshold) {
        super(tag, "lowFertilizer");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection direction, TileEntity tile, ITriggerParameter parameter) {
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        ItemStack fertilizer = central.getInventory().func_70301_a(20);
        if (fertilizer == null) {
            return true;
        }
        return (float)fertilizer.field_77994_a / (float)fertilizer.func_77976_d() <= this.threshold;
    }
}

