/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.core.genetics.AlleleSpecies;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class AlleleButterflySpecies
extends AlleleSpecies
implements IAlleleButterflySpecies {
    private final IButterflyRoot root;
    private final String texture;
    private final int serumColour;
    private float rarity = 0.1f;
    private float flightDistance = 5.0f;
    private boolean isActualNocturnal = false;
    private final EnumSet<BiomeDictionary.Type> spawnBiomes = EnumSet.noneOf(BiomeDictionary.Type.class);
    private final Map<ItemStack, Float> butterflyLoot = new HashMap<ItemStack, Float>();
    private final Map<ItemStack, Float> caterpillarLoot = new HashMap<ItemStack, Float>();

    public AlleleButterflySpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int serumColour) {
        super(uid, isDominant, "butterflies.species." + branch.getParent().getUID().substring(branch.getParent().getLevel().name().toLowerCase(Locale.ENGLISH).length() + 1) + "." + name, branch, binomial);
        this.root = (IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
        this.serumColour = serumColour;
        this.texture = "forestry:textures/entity/butterflies/" + uid + ".png";
    }

    @Override
    public IButterflyRoot getRoot() {
        return this.root;
    }

    public AlleleButterflySpecies setRarity(float rarity) {
        this.rarity = rarity;
        return this;
    }

    public AlleleButterflySpecies setFlightDistance(float flightDistance) {
        this.flightDistance = flightDistance;
        return this;
    }

    public AlleleButterflySpecies setNocturnal(boolean isActualNocturnal) {
        this.isActualNocturnal = isActualNocturnal;
        return this;
    }

    public AlleleButterflySpecies addSpawnBiomes(EnumSet<BiomeDictionary.Type> biomeTags) {
        this.spawnBiomes.addAll(biomeTags);
        return this;
    }

    public AlleleButterflySpecies addSpawnBiome(BiomeDictionary.Type biomeTag) {
        this.spawnBiomes.add(biomeTag);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return null;
    }

    @Override
    public String getEntityTexture() {
        return this.texture;
    }

    @Override
    public EnumSet<BiomeDictionary.Type> getSpawnBiomes() {
        return this.spawnBiomes;
    }

    @Override
    public boolean strictSpawnMatch() {
        return false;
    }

    @Override
    public int getComplexity() {
        return (int)((double)(1.35f / this.rarity) * 1.5);
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (itemstack.func_77973_b() == Items.field_151069_bo) {
            return 0.9f;
        }
        for (ItemStack stack : this.butterflyLoot.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack stack : this.caterpillarLoot.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(itemstack);
    }

    @Override
    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        return new ItemStack[]{this.getRoot().getMemberStack(individual.copy(), EnumFlutterType.SERUM.ordinal())};
    }

    @Override
    public boolean isSecret() {
        return this.rarity < 0.8f;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public float getFlightDistance() {
        return this.flightDistance;
    }

    @Override
    public boolean isNocturnal() {
        return this.isActualNocturnal;
    }

    @Override
    public Map<ItemStack, Float> getButterflyLoot() {
        return this.butterflyLoot;
    }

    @Override
    public Map<ItemStack, Float> getCaterpillarLoot() {
        return this.caterpillarLoot;
    }

    @Override
    public int getIconColour(int renderPass) {
        if (renderPass > 0) {
            return 0xFFFFFF;
        }
        return this.serumColour;
    }
}

