/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.ILetter;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostRegistry;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.core.config.ForestryItem;
import forestry.mail.Letter;
import forestry.mail.POBox;
import forestry.mail.PostOffice;
import forestry.mail.TradeStation;
import forestry.mail.items.ItemLetter;
import forestry.plugins.PluginMail;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class PostRegistry
implements IPostRegistry {
    public static PostOffice cachedPostOffice;
    public static HashMap<MailAddress, POBox> cachedPOBoxes;
    public static HashMap<MailAddress, ITradeStation> cachedTradeStations;
    private final HashMap<String, IPostalCarrier> carriers = new HashMap();

    @Override
    public boolean isValidPOBox(World world, MailAddress address) {
        return address.isPlayer() && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    public static POBox getPOBox(World world, MailAddress address) {
        if (cachedPOBoxes.containsKey(address)) {
            return cachedPOBoxes.get(address);
        }
        POBox pobox = (POBox)world.func_72943_a(POBox.class, "POBox_" + address);
        if (pobox != null) {
            cachedPOBoxes.put(address, pobox);
        }
        return pobox;
    }

    public static POBox getOrCreatePOBox(World world, MailAddress address) {
        POBox pobox = PostRegistry.getPOBox(world, address);
        if (pobox == null) {
            pobox = new POBox(address);
            world.func_72823_a("POBox_" + address, (WorldSavedData)pobox);
            pobox.func_70296_d();
            cachedPOBoxes.put(address, pobox);
            PluginMail.proxy.setPOBoxInfo(world, address, pobox.getPOBoxInfo());
        }
        return pobox;
    }

    @Override
    public boolean isValidTradeAddress(World world, MailAddress address) {
        return !address.isPlayer() && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    @Override
    public boolean isAvailableTradeAddress(World world, MailAddress address) {
        return this.getTradeStation(world, address) == null;
    }

    @Override
    public TradeStation getTradeStation(World world, MailAddress address) {
        if (cachedTradeStations.containsKey(address)) {
            return (TradeStation)cachedTradeStations.get(address);
        }
        TradeStation trade = (TradeStation)world.func_72943_a(TradeStation.class, "TradePO_" + address);
        if (trade != null && trade.isValid()) {
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
            return trade;
        }
        return null;
    }

    @Override
    public TradeStation getOrCreateTradeStation(World world, GameProfile owner, MailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            trade = new TradeStation(owner, address);
            world.func_72823_a("TradePO_" + address, (WorldSavedData)trade);
            trade.func_70296_d();
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
        }
        return trade;
    }

    @Override
    public void deleteTradeStation(World world, MailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(address);
        this.getPostOffice(world).deregisterTradeStation(trade);
        File file = world.func_72860_G().func_75758_b(trade.field_76190_i);
        file.delete();
    }

    @Override
    public IPostOffice getPostOffice(World world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.func_72943_a(PostOffice.class, "ForestryMail");
        if (office == null) {
            office = new PostOffice();
            world.func_72823_a("ForestryMail", (WorldSavedData)office);
        }
        office.setWorld(world);
        cachedPostOffice = office;
        return office;
    }

    @Override
    public Map<String, IPostalCarrier> getRegisteredCarriers() {
        return this.carriers;
    }

    @Override
    public void registerCarrier(IPostalCarrier carrier) {
        this.carriers.put(carrier.getUID(), carrier);
    }

    @Override
    public IPostalCarrier getCarrier(String uid) {
        return this.carriers.get(uid);
    }

    @Override
    public ILetter createLetter(MailAddress sender, MailAddress recipient) {
        return new Letter(sender, recipient);
    }

    @Override
    public ItemStack createLetterStack(ILetter letter) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        letter.writeToNBT(nbttagcompound);
        ItemStack mailstack = ForestryItem.letters.getItemStack(1, ItemLetter.encodeMeta(1, ItemLetter.getType(letter)));
        mailstack.func_77982_d(nbttagcompound);
        return mailstack;
    }

    @Override
    public ILetter getLetter(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        if (!PostManager.postRegistry.isLetter(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Letter(itemstack.func_77978_p());
    }

    @Override
    public boolean isLetter(ItemStack itemstack) {
        return ForestryItem.letters.isItemEqual(itemstack);
    }

    static {
        cachedPOBoxes = new HashMap();
        cachedTradeStations = new HashMap();
    }
}

