/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.ILetter;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotClosed;
import forestry.core.gui.slots.SlotCustom;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.mail.EnumAddressee;
import forestry.mail.Letter;
import forestry.mail.items.ItemLetter;
import forestry.mail.items.ItemStamps;
import forestry.mail.network.PacketTradeInfo;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerLetter
extends ContainerItemInventory {
    private final ItemLetter.LetterInventory letterInventory;
    private String carrier = EnumAddressee.PLAYER.toString().toLowerCase(Locale.ENGLISH);
    private TradeStationInfo tradeInfo = null;

    public ContainerLetter(EntityPlayer player, ItemLetter.LetterInventory inventory) {
        super(inventory, player);
        int j;
        int i;
        this.letterInventory = inventory;
        if (Proxies.common.isSimulating(player.field_70170_p) && this.letterInventory.getLetter().isProcessed() && inventory.parent != null && ItemLetter.getState(inventory.parent.func_77960_j()) < 2) {
            inventory.parent.func_77964_b(ItemLetter.encodeMeta(2, ItemLetter.getSize(inventory.parent.func_77960_j())));
        }
        Object[] validStamps = new Object[]{ItemStamps.class};
        if (this.letterInventory.getLetter().isProcessed()) {
            validStamps = new Object[]{};
        }
        for (i = 0; i < 4; ++i) {
            this.addSlot(new SlotCustom((IInventory)inventory, Letter.SLOT_POSTAGE_1 + i, 150, 14 + i * 19, validStamps).setStackLimit(1));
        }
        if (!this.letterInventory.getLetter().isProcessed()) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.addSlot(new SlotCustom((IInventory)inventory, Letter.SLOT_ATTACHMENT_1 + j + i * 9, 17 + j * 18, 98 + i * 18, true, new Object[]{ItemLetter.class}));
                }
            }
        } else {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.addSlot(new SlotClosed(inventory, Letter.SLOT_ATTACHMENT_1 + j + i * 9, 17 + j * 18, 98 + i * 18));
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSecuredSlot((IInventory)player.field_71071_by, j + i * 9 + 9, 17 + j * 18, 145 + i * 18);
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSecuredSlot((IInventory)player.field_71071_by, i, 17 + i * 18, 203);
        }
        if (this.letterInventory.getLetter() != null && this.letterInventory.getLetter().getRecipients() != null && this.letterInventory.getLetter().getRecipients().length > 0) {
            this.carrier = this.letterInventory.getLetter().getRecipients()[0].getType();
        }
    }

    @Override
    public void func_75134_a(EntityPlayer entityplayer) {
        ILetter letter;
        if (Proxies.common.isSimulating(entityplayer.field_70170_p) && !(letter = this.letterInventory.getLetter()).isProcessed()) {
            letter.setSender(new MailAddress(entityplayer.func_146103_bH()));
        }
        super.func_75134_a(entityplayer);
    }

    @Override
    protected boolean isAcceptedItem(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public ILetter getLetter() {
        return this.letterInventory.getLetter();
    }

    public void setCarrierType(String type) {
        this.carrier = type;
    }

    public String getCarrierType() {
        return this.carrier;
    }

    public void advanceCarrierType() {
        Iterator<IPostalCarrier> it = PostManager.postRegistry.getRegisteredCarriers().values().iterator();
        while (it.hasNext() && !it.next().getUID().equals(this.carrier)) {
        }
        IPostalCarrier postal = null;
        postal = it.hasNext() ? it.next() : PostManager.postRegistry.getRegisteredCarriers().values().iterator().next();
        this.setCarrierType(postal.getUID());
    }

    public void setRecipient(MailAddress address) {
        if (address == null) {
            return;
        }
        this.getLetter().setRecipient(address);
        this.carrier = address.getType();
        PacketPayload payload = new PacketPayload(0, 0, 2);
        payload.stringPayload[0] = this.getRecipient().getName();
        payload.stringPayload[1] = this.carrier;
        PacketUpdate packet = new PacketUpdate(80, payload);
        Proxies.net.sendToServer(packet);
    }

    public void handleSetRecipient(EntityPlayer player, PacketUpdate packet) {
        String identifierName = packet.payload.stringPayload[0];
        String type = packet.payload.stringPayload[1];
        MailAddress recipient = MailAddress.makeMailAddress(identifierName, type);
        this.getLetter().setRecipient(recipient);
        this.updateTradeInfo(player.field_70170_p, recipient);
        Proxies.net.sendToPlayer(new PacketTradeInfo(83, this.tradeInfo), player);
    }

    public MailAddress getRecipient() {
        if (this.getLetter().getRecipients().length > 0) {
            return this.getLetter().getRecipients()[0];
        }
        return null;
    }

    public String getText() {
        return this.getLetter().getText();
    }

    public void setText(String text) {
        this.getLetter().setText(text);
        PacketPayload payload = new PacketPayload(0, 0, 1);
        payload.stringPayload[0] = text;
        PacketUpdate packet = new PacketUpdate(81, payload);
        Proxies.net.sendToServer(packet);
    }

    public void handleSetText(PacketUpdate packet) {
        this.getLetter().setText(packet.payload.stringPayload[0]);
    }

    public void updateTradeInfo(World world, MailAddress address) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        if (address.isPlayer()) {
            return;
        }
        ITradeStation station = PostManager.postRegistry.getTradeStation(world, address);
        if (station == null) {
            return;
        }
        this.setTradeInfo(station.getTradeInfo());
    }

    public void handleTradeInfoUpdate(PacketTradeInfo packet) {
        this.setTradeInfo(packet.tradeInfo);
    }

    public TradeStationInfo getTradeInfo() {
        return this.tradeInfo;
    }

    private void setTradeInfo(TradeStationInfo info) {
        this.tradeInfo = info;
    }
}

