/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.MailAddress;
import forestry.api.mail.TradeStationInfo;
import forestry.core.network.ForestryPacket;
import forestry.mail.EnumStationState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.item.ItemStack;

public class PacketTradeInfo
extends ForestryPacket {
    public TradeStationInfo tradeInfo;

    public PacketTradeInfo() {
    }

    public PacketTradeInfo(int id, TradeStationInfo info) {
        super(id);
        this.tradeInfo = info;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        if (this.tradeInfo == null) {
            data.writeShort(-1);
            return;
        }
        data.writeShort(0);
        data.writeUTF(this.tradeInfo.address.getName());
        data.writeLong(this.tradeInfo.owner.getId().getMostSignificantBits());
        data.writeLong(this.tradeInfo.owner.getId().getLeastSignificantBits());
        data.writeUTF(this.tradeInfo.owner.getName());
        this.writeItemStack(this.tradeInfo.tradegood, data);
        data.writeShort(this.tradeInfo.required.length);
        for (int i = 0; i < this.tradeInfo.required.length; ++i) {
            this.writeItemStack(this.tradeInfo.required[i], data);
        }
        data.writeShort(this.tradeInfo.state.ordinal());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        short isNotNull = data.readShort();
        if (isNotNull < 0) {
            return;
        }
        MailAddress address = new MailAddress(data.readUTF());
        GameProfile owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF());
        ItemStack tradegood = this.readItemStack(data);
        ItemStack[] required = new ItemStack[data.readShort()];
        for (int i = 0; i < required.length; ++i) {
            required[i] = this.readItemStack(data);
        }
        this.tradeInfo = new TradeStationInfo(address, owner, tradegood, required, EnumStationState.values()[data.readShort()]);
    }
}

