/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes.network;

import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.pipes.PipeItemsPropolis;
import forestry.pipes.PipeLogicPropolis;
import forestry.pipes.gui.ContainerPropolisPipe;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandlerPipes
implements IPacketHandler {
    private Pipe getPipe(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return ((TileGenericPipe)tile).pipe;
    }

    @Override
    public void onPacketData(int packetID, DataInputStream data, EntityPlayer player) {
        try {
            switch (packetID) {
                case 100: {
                    PacketNBT packetN = new PacketNBT();
                    packetN.readData(data);
                    this.onFilterSet(packetN);
                    break;
                }
                case 101: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onRequestFilterSet(player, packetC);
                    break;
                }
                case 103: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onTypeFilterChange(player, packetU);
                    break;
                }
                case 102: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onGenomeFilterChange(player, packetU);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onFilterSet(PacketNBT packet) {
        Container container = Proxies.common.getClientInstance().field_71439_g.field_71070_bA;
        if (container instanceof ContainerPropolisPipe) {
            PipeLogicPropolis pipeLogic = ((ContainerPropolisPipe)container).pipeLogic;
            pipeLogic.handleFilterSet(packet);
        }
    }

    private void onTypeFilterChange(EntityPlayer player, PacketUpdate packet) {
        Pipe pipe = this.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe instanceof PipeItemsPropolis) {
            ((PipeItemsPropolis)pipe).pipeLogic.handleTypeFilterChange(packet.payload);
        }
    }

    private void onGenomeFilterChange(EntityPlayer player, PacketUpdate packet) {
        Pipe pipe = this.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe instanceof PipeItemsPropolis) {
            ((PipeItemsPropolis)pipe).pipeLogic.handleGenomeFilterChange(packet.payload);
        }
    }

    private void onRequestFilterSet(EntityPlayer player, PacketCoordinates packet) {
        Pipe pipe = this.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe instanceof PipeItemsPropolis) {
            ((PipeItemsPropolis)pipe).pipeLogic.sendFilterSet(player);
        }
    }
}

