/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import forestry.api.core.IPlugin;
import forestry.api.core.PluginInfo;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryItem;
import forestry.core.items.ItemCrated;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.StackUtils;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@PluginInfo(pluginID="IC2", name="IndustrialCraft2", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for IC2.")
public class PluginIC2
implements IPlugin {
    public static PluginIC2 instance;
    public static Configuration config;
    public static boolean ignore;
    public static ItemStack plantBall;
    public static ItemStack compressedPlantBall;
    public static ItemStack wrench;
    public static ItemStack treetap;
    public static ItemStack resin;
    public static ItemStack rubbersapling;
    public static ItemStack rubberwood;
    public static ItemStack rubberleaves;
    public static ItemStack fuelcanFilled;
    public static ItemStack fuelcanEmpty;
    public static ItemStack emptyCell;
    public static ItemStack lavaCell;
    public static ItemStack waterCell;
    public static ItemStack rubber;
    public static ItemStack scrap;
    public static ItemStack silver;
    public static ItemStack brass;
    public static ItemStack uuMatter;
    public static int fuelcanMeta;

    public PluginIC2() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("IC2");
    }

    @Override
    public void doInit() {
        config = Config.config;
        if (!this.isAvailable()) {
            return;
        }
        new Impl().init();
    }

    @Override
    public void preInit() {
    }

    @Override
    public void postInit() {
    }

    private static class Impl {
        private Impl() {
        }

        private void init() {
            this.initLiquidContainers();
            this.initRubberChain();
            this.initFermentation();
            this.initCrates();
            Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(ForestryItem.beeQueenGE.getItemStack()));
            Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(ForestryItem.beePrincessGE.getItemStack()));
            this.registerBackpackItems();
            if (rubbersapling != null && resin != null) {
                String imc = String.format("farmArboreal@%s.%s.%s.%s", GameData.getBlockRegistry().func_148750_c((Object)StackUtils.getBlock(rubbersapling)), rubbersapling.func_77960_j(), GameData.getItemRegistry().func_148750_c((Object)resin.func_77973_b()), resin.func_77960_j());
                Proxies.log.finest("Sending IMC '%s'.", (Object)imc);
                FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)imc);
            }
        }

        private void initFermentation() {
            plantBall = IC2Items.getItem((String)"plantBall");
            compressedPlantBall = IC2Items.getItem((String)"compressedPlantBall");
            if (plantBall == null || compressedPlantBall == null) {
                Proxies.log.fine("No IC2 plantballs found.");
                return;
            }
            RecipeUtil.injectLeveledRecipe(plantBall, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat") * 4, "biomass");
            RecipeUtil.injectLeveledRecipe(compressedPlantBall, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat") * 5, "biomass");
        }

        private void initLiquidContainers() {
            emptyCell = IC2Items.getItem((String)"cell");
            lavaCell = IC2Items.getItem((String)"lavaCell");
            waterCell = IC2Items.getItem((String)"waterCell");
            if (emptyCell == null || lavaCell == null || waterCell == null) {
                Proxies.log.fine("Any of the following IC2 items could not be found: empty cell, water cell, lava cell. Skipped adding IC2 liquid containers.");
                return;
            }
            LiquidHelper.injectTinContainer("lava", 1000, lavaCell, emptyCell);
            LiquidHelper.injectTinContainer("water", 1000, waterCell, emptyCell);
            if (GameMode.getGameMode().getStackSetting((String)"recipe.output.bogearth.can").field_77994_a > 0) {
                Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waterCell, Character.valueOf('Y'), Blocks.field_150354_m);
            }
        }

        private void initRubberChain() {
            treetap = IC2Items.getItem((String)"treetap");
            rubberwood = IC2Items.getItem((String)"rubberWood");
            resin = IC2Items.getItem((String)"resin");
            if (resin != null) {
                RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.propolis.getItemStack(), resin);
            } else {
                Proxies.log.fine("Missing IC2 resin, skipping centrifuge recipe for propolis to resin.");
            }
            fuelcanFilled = IC2Items.getItem((String)"filledFuelCan");
            fuelcanEmpty = IC2Items.getItem((String)"fuelCan");
            if (fuelcanEmpty != null && fuelcanFilled != null) {
                ItemStack fuelcanStack = new ItemStack(fuelcanFilled.func_77973_b(), 1, 0);
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("value", 15288);
                fuelcanStack.func_77982_d(compound);
                RecipeManagers.bottlerManager.addRecipe(20, LiquidHelper.getLiquid("bioethanol", 2000), fuelcanEmpty, fuelcanStack);
            } else {
                Proxies.log.fine("Missing IC2 fuelcanEmpty or fuelcanFilled, skipping bottler recipe for ethanol to filled fuel can.");
            }
            rubbersapling = IC2Items.getItem((String)"rubberSapling");
            if (rubbersapling != null) {
                RecipeUtil.injectLeveledRecipe(rubbersapling, GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
                BackpackManager.backpackItems[2].add(rubbersapling);
            } else {
                Proxies.log.fine("Missing IC2 rubber sapling, skipping fermenter recipe for converting rubber sapling to biomass.");
            }
            rubberleaves = IC2Items.getItem((String)"rubberLeaves");
            if (rubberleaves != null) {
                BackpackManager.backpackItems[2].add(rubberleaves);
            } else {
                Proxies.log.fine("Missing IC2 rubber leaves");
            }
        }

        private void initCrates() {
            resin = IC2Items.getItem((String)"resin");
            if (resin != null) {
                ForestryItem.cratedResin.registerItem(new ItemCrated(), "cratedResin");
                ((ItemCrated)ForestryItem.cratedResin.item()).setContained(ForestryItem.cratedResin.getItemStack(), resin);
            }
            if ((rubber = IC2Items.getItem((String)"rubber")) != null) {
                ForestryItem.cratedRubber.registerItem(new ItemCrated(), "cratedRubber");
                ((ItemCrated)ForestryItem.cratedRubber.item()).setContained(ForestryItem.cratedRubber.getItemStack(), rubber);
            }
            if ((scrap = IC2Items.getItem((String)"scrap")) != null) {
                ForestryItem.cratedScrap.registerItem(new ItemCrated(), "cratedScrap");
                ((ItemCrated)ForestryItem.cratedScrap.item()).setContained(ForestryItem.cratedScrap.getItemStack(), scrap);
            }
            if ((uuMatter = IC2Items.getItem((String)"matter")) != null) {
                ForestryItem.cratedUUM.registerItem(new ItemCrated(), "cratedUUM");
                ((ItemCrated)ForestryItem.cratedUUM.item()).setContained(ForestryItem.cratedUUM.getItemStack(), uuMatter);
            }
            if ((silver = IC2Items.getItem((String)"silverIngot")) != null) {
                ForestryItem.cratedSilver.registerItem(new ItemCrated(), "cratedSilver");
                ((ItemCrated)ForestryItem.cratedSilver.item()).setContained(ForestryItem.cratedSilver.getItemStack(), silver);
            }
            if ((brass = IC2Items.getItem((String)"bronzeIngot")) != null) {
                ForestryItem.cratedBrass.registerItem(new ItemCrated(), "cratedBrass");
                ((ItemCrated)ForestryItem.cratedBrass.item()).setContained(ForestryItem.cratedBrass.getItemStack(), brass);
            }
        }

        private void registerBackpackItems() {
            if (BackpackManager.backpackItems == null) {
                return;
            }
            if (resin != null) {
                BackpackManager.definitions.get("forester").addValidItem(resin);
            }
            if (rubber != null) {
                BackpackManager.definitions.get("forester").addValidItem(rubber);
            }
        }
    }
}

