/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCore;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;

public class MalisisCommand
extends CommandBase {
    Set<String> parameters = new HashSet<String>();

    public MalisisCommand() {
        this.parameters.add("config");
        this.parameters.add("version");
    }

    public String func_71517_b() {
        return "malisis";
    }

    public String func_71518_a(ICommandSender sender) {
        return "malisiscore.commands.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] params) {
        if (params.length == 0) {
            throw new WrongUsageException("malisiscore.commands.usage", new Object[0]);
        }
        if (!this.parameters.contains(params[0])) {
            throw new WrongUsageException("malisiscore.commands.usage", new Object[0]);
        }
        switch (params[0]) {
            case "config": {
                this.configCommand(sender, params);
                break;
            }
            case "version": {
                IMalisisMod mod = null;
                if (params.length == 1) {
                    mod = MalisisCore.instance;
                } else {
                    mod = MalisisCore.getMod(params[1]);
                    if (mod == null) {
                        MalisisCore.message("malisiscore.commands.modnotfound", params[1]);
                    }
                }
                if (mod == null) break;
                MalisisCore.message("malisiscore.commands.modversion", mod.getName(), mod.getVersion());
                break;
            }
            case "gui": {
                break;
            }
            default: {
                MalisisCore.message("Not yet implemented", new Object[0]);
            }
        }
    }

    public boolean func_71519_b(ICommandSender icommandsender) {
        return true;
    }

    public List func_71516_a(ICommandSender icommandsender, String[] params) {
        if (params.length == 1) {
            return MalisisCommand.func_71531_a((String[])params, this.parameters);
        }
        if (params.length == 2) {
            return MalisisCommand.func_71531_a((String[])params, MalisisCore.listModId());
        }
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    public void configCommand(ICommandSender sender, String[] params) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MalisisCore.log.warn("Can't open configuration GUI on a dedicated server.");
            return;
        }
        IMalisisMod mod = null;
        if (params.length == 1) {
            mod = MalisisCore.instance;
        } else {
            mod = MalisisCore.getMod(params[1]);
            if (mod == null) {
                MalisisCore.message("malisiscore.commands.modnotfound", params[1]);
            }
        }
        if (mod != null && !MalisisCore.openConfigurationGui(mod, true)) {
            MalisisCore.message("malisiscore.commands.noconfiguration", mod.getName());
        }
    }
}

