/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class ProxyBlock
extends Block {
    public final Block originalBlock;
    @SideOnly(value=Side.CLIENT)
    private Icon iconGrassTop;
    @SideOnly(value=Side.CLIENT)
    private Icon iconSnowSide;
    @SideOnly(value=Side.CLIENT)
    private Icon iconGrassSideOverlay;

    public ProxyBlock(int blockID, Block block) {
        super(blockID, block.field_149764_J);
        this.originalBlock = block;
        this.copyFields(block, false);
    }

    public ProxyBlock(Block block) {
        super(ProxyBlock.freeId(block.blockID), block.field_149764_J);
        this.originalBlock = block;
        this.copyFields(block, true);
    }

    private static int freeId(int id) {
        Block.blocksList[id] = null;
        return id;
    }

    private void copyFields(Block block, boolean copyId) {
        for (Class<?> blockClass = block.getClass(); blockClass != null; blockClass = blockClass.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = blockClass.getDeclaredFields()) {
                try {
                    if (Modifier.isStatic(f.getModifiers()) || !copyId && (f.getName().equals("blockID") || f.getName().equals("field_71990_ca"))) continue;
                    f.setAccessible(true);
                    f.set((Object)this, f.get(block));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.originalBlock.isBlockSolidOnSide(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int metadata) {
        return this.originalBlock.getIcon(side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTexture(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this.originalBlock.getBlockTexture(par1IBlockAccess, par2, par3, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister par1IconRegister) {
        this.originalBlock.registerIcons(par1IconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.originalBlock.func_149635_D();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int par1) {
        return this.originalBlock.func_149741_i(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.originalBlock.func_149720_d(par1IBlockAccess, par2, par3, par4);
    }

    public int idDropped(int par1, Random par2Random, int par3) {
        return this.originalBlock.idDropped(par1, par2Random, par3);
    }

    public int idPicked(World world, int x, int y, int z) {
        return this.originalBlock.idPicked(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.originalBlock.func_149674_a(world, x, y, z, rand);
    }

    public int func_149738_a(World par1World) {
        return this.originalBlock.func_149738_a(par1World);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer p) {
        this.originalBlock.func_149699_a(world, x, y, z, p);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer p, int par6, float par7, float par8, float par9) {
        return this.originalBlock.func_149727_a(world, x, y, z, p, par6, par7, par8, par9);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.originalBlock.func_149726_b(world, x, y, z);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return this.originalBlock.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, metadata);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int metadata) {
        this.originalBlock.onNeighborBlockChange(world, x, y, z, metadata);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return this.originalBlock.func_149646_a(world, x, y, z, side);
    }

    public int func_149645_b() {
        return this.originalBlock.func_149645_b();
    }
}

