/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.UISlot;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.event.GuiEvent;
import net.malisis.core.client.gui.event.KeyboardEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.player.PlayerInventorySlot;
import net.malisis.core.packet.InventoryActionMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class MalisisGui
extends GuiScreen {
    protected GuiRenderer renderer = new GuiRenderer();
    private UIContainer screen = new UIContainer();
    protected UIContainer container;
    protected boolean guiscreenBackground = true;
    protected int lastMouseX;
    protected int lastMouseY;
    protected long lastClick = 0L;
    protected MalisisInventoryContainer inventoryContainer;
    protected UIComponent hoveredComponent;
    protected UIComponent focusedComponent;
    private long startTime;
    private long elaspedTime;

    public MalisisGui(UIContainer container) {
        this();
        this.addToScreen(container);
    }

    protected MalisisGui() {
        this.screen.clipContent = false;
        this.startTime = System.currentTimeMillis();
    }

    public void setInventoryContainer(MalisisInventoryContainer container) {
        this.inventoryContainer = container;
    }

    public MalisisInventoryContainer getInventoryContainer() {
        return this.inventoryContainer;
    }

    public long getElapsedTime() {
        return this.elaspedTime;
    }

    protected void addToScreen(UIContainer container) {
        this.container = container;
        this.screen.add(container);
    }

    protected boolean fireEvent(GuiEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            UIComponent component = this.container.getComponentAt(me.getX(), me.getY());
            if (component != null) {
                if (me instanceof MouseEvent.Press) {
                    component.setFocused(true);
                } else if (me instanceof MouseEvent.Move) {
                    component.setHovered(true);
                }
                component.fireMouseEvent(me);
            }
        } else if (event instanceof KeyboardEvent) {
            this.container.fireKeyboardEvent((KeyboardEvent)event);
        }
        return !event.isCancelled();
    }

    public void func_146274_d() {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int delta = Mouse.getEventDWheel();
        if (delta == 0) {
            return;
        }
        if (delta > 1) {
            delta = 1;
        } else if (delta < -1) {
            delta = -1;
        }
        this.fireEvent(new MouseEvent.ScrollWheel(mouseX, mouseY, delta));
    }

    protected void func_73864_a(int x, int y, int button) {
        long time = System.currentTimeMillis();
        if (button == 0 && time - this.lastClick < 250L) {
            this.doubleClick(x, y, button);
            this.lastClick = 0L;
            return;
        }
        if (this.container.isInsideBounds(x, y)) {
            this.fireEvent(new MouseEvent.Press(x, y, button));
        } else if (this.inventoryContainer != null && this.inventoryContainer.getPickedItemStack() != null) {
            MalisisInventoryContainer.ActionType action = button == 1 ? MalisisInventoryContainer.ActionType.DROP_ONE : MalisisInventoryContainer.ActionType.DROP_STACK;
            MalisisGui.sendAction(action, null, button);
        }
        this.lastClick = time;
    }

    protected void func_146273_a(int x, int y, int button, long timer) {
        if (this.focusedComponent != null) {
            this.focusedComponent.fireMouseEvent(new MouseEvent.Drag(this.lastMouseX, this.lastMouseY, x, y, button));
        }
    }

    protected void func_146286_b(int x, int y, int button) {
        if (this.inventoryContainer != null) {
            if (this.inventoryContainer.shouldResetDrag(button)) {
                MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_RESET, null, 0);
                UISlot.buttonRelased = false;
                return;
            }
            if (this.inventoryContainer.shouldEndDrag(button)) {
                MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_END, null, 0);
                return;
            }
        }
        if (this.container.isInsideBounds(x, y)) {
            this.fireEvent(new MouseEvent.Release(x, y, button));
        }
    }

    protected void doubleClick(int x, int y, int button) {
        if (this.container.isInsideBounds(x, y)) {
            this.fireEvent(new MouseEvent.DoubleClick(x, y, button));
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        KeyboardEvent event = new KeyboardEvent(keyChar, keyCode);
        this.container.fireKeyboardEvent(event);
        if (event.isCancelled()) {
            return;
        }
        if (keyCode == 1 || this.inventoryContainer != null && keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.close();
        }
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        this.screen.setSize(width, height);
        this.renderer.updateGuiScale();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.elaspedTime = System.currentTimeMillis() - this.startTime;
        this.update(mouseX, mouseY, partialTicks);
        if (this.guiscreenBackground) {
            this.func_146270_b(1);
        }
        if (this.container == null) {
            return;
        }
        if (this.container.isInsideBounds(mouseX, mouseY) && (this.lastMouseX != mouseX || this.lastMouseY != mouseY)) {
            this.fireEvent(new MouseEvent.Move(this.lastMouseX, this.lastMouseY, mouseX, mouseY));
        }
        RenderHelper.func_74520_c();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        this.renderer.drawScreen(this.container, mouseX, mouseY, partialTicks);
        if (this.inventoryContainer != null) {
            ItemStack itemStack = this.inventoryContainer.getPickedItemStack();
            if (itemStack != null) {
                this.renderer.renderPickedItemStack(itemStack);
            } else if (this.hoveredComponent != null) {
                this.renderer.drawTooltip(this.hoveredComponent.getTooltip());
            }
        } else if (this.hoveredComponent != null) {
            this.renderer.drawTooltip(this.hoveredComponent.getTooltip());
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void update(int mouseX, int mouseY, float partialTick) {
    }

    public void updateGui() {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void display() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
    }

    public void close() {
        this.field_146297_k.field_71439_g.func_71053_j();
        this.field_146297_k.func_147108_a((GuiScreen)null);
        this.field_146297_k.func_71381_h();
    }

    public static MalisisGui currentGui() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof MalisisGui) {
            return (MalisisGui)gui;
        }
        return null;
    }

    public static void sendAction(MalisisInventoryContainer.ActionType action, MalisisSlot slot, int code) {
        if (action == null || MalisisGui.currentGui() == null || MalisisGui.currentGui().inventoryContainer == null) {
            return;
        }
        int slotNumber = slot != null ? slot.slotNumber : 0;
        boolean playerInv = slot instanceof PlayerInventorySlot;
        MalisisGui.currentGui().inventoryContainer.handleAction(action, slotNumber, code, playerInv);
        InventoryActionMessage.sendAction(action, slotNumber, code, playerInv);
    }

    public static boolean setHoveredComponent(UIComponent component, boolean hovered) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.hoveredComponent == component) {
            if (!hovered) {
                gui.hoveredComponent = null;
                return true;
            }
            return false;
        }
        if (gui.hoveredComponent != null) {
            gui.hoveredComponent.setHovered(false);
        }
        gui.hoveredComponent = component;
        return true;
    }

    public static UIComponent getFocusedComponent() {
        return MalisisGui.currentGui() != null ? MalisisGui.currentGui().focusedComponent : null;
    }

    public static boolean setFocusedComponent(UIComponent component, boolean focused) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.focusedComponent == component) {
            if (!focused) {
                gui.focusedComponent = null;
                return true;
            }
            return false;
        }
        if (gui.focusedComponent != null && component != null) {
            gui.focusedComponent.setFocused(false);
        }
        gui.focusedComponent = component;
        return true;
    }
}

