/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component;

import com.google.common.eventbus.EventBus;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.component.interaction.IScrollable;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.KeyboardEvent;
import net.malisis.core.client.gui.event.MouseEvent;

public abstract class UIComponent<T extends UIComponent> {
    public static final int INHERITED = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    protected int zIndex = Integer.MIN_VALUE;
    protected int anchor;
    protected int width;
    protected int height;
    private EventBus bus = new EventBus();
    protected UIContainer parent;
    protected String name;
    protected UITooltip tooltip;
    protected boolean visible = true;
    protected boolean disabled = false;
    protected boolean hovered;
    protected boolean focused;

    public UIComponent() {
        this.bus.register((Object)this);
        this.visible = true;
    }

    public T register(Object object) {
        this.bus.register(object);
        return (T)this;
    }

    public T unregister(Object object) {
        this.bus.unregister(object);
        return (T)this;
    }

    public boolean fireEvent(ComponentEvent event) {
        this.bus.post((Object)event);
        return !event.isCancelled();
    }

    public boolean fireMouseEvent(MouseEvent event) {
        if (this.isDisabled() || !this.isVisible()) {
            return false;
        }
        this.bus.post((Object)event);
        return !event.isCancelled();
    }

    public boolean fireKeyboardEvent(KeyboardEvent event) {
        if (this.isDisabled()) {
            return false;
        }
        this.bus.post((Object)event);
        return !event.isCancelled();
    }

    public T setPosition(int x, int y) {
        return this.setPosition(x, y, Anchor.NONE);
    }

    public T setPosition(int x, int y, int anchor) {
        this.x = x;
        this.y = y;
        this.anchor = anchor;
        if (this.parent != null) {
            this.parent.onContentUpdate();
        }
        return (T)this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public T setZIndex(int zIndex) {
        this.zIndex = zIndex;
        return (T)this;
    }

    public int getZIndex() {
        return this.zIndex == Integer.MIN_VALUE ? 0 : this.zIndex;
    }

    public T setAnchor(int anchor) {
        this.anchor = anchor;
        return (T)this;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public T setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.parent != null) {
            this.parent.onContentUpdate();
        }
        return (T)this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHovered(boolean hovered) {
        boolean flag;
        boolean bl = flag = this.hovered != hovered;
        if (!(flag |= MalisisGui.setHoveredComponent(this, hovered))) {
            return;
        }
        this.hovered = hovered;
        this.fireEvent(new ComponentEvent.HoveredStateChanged<UIComponent>(this, hovered));
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setFocused(boolean focused) {
        boolean flag;
        if (this.isDisabled()) {
            return;
        }
        boolean bl = flag = this.focused != focused;
        if (!(flag |= MalisisGui.setFocusedComponent(this, focused))) {
            return;
        }
        this.focused = focused;
        this.fireEvent(new ComponentEvent.FocusStateChanged<UIComponent>(this, focused));
    }

    public boolean isFocused() {
        return this.focused;
    }

    public UIContainer getParent() {
        return this.parent;
    }

    public void setParent(UIContainer parent) {
        this.parent = parent;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public T setVisible(boolean visible) {
        this.visible = visible;
        if (!visible) {
            this.setHovered(false);
            this.setFocused(false);
        }
        if (this.parent != null) {
            this.parent.onContentUpdate();
        }
        return (T)this;
    }

    public boolean isDisabled() {
        return this.disabled || this.parent != null && this.parent.isDisabled();
    }

    public T setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (disabled) {
            this.setHovered(false);
            this.setFocused(false);
        }
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UITooltip getTooltip() {
        return this.tooltip;
    }

    public T setTooltip(UITooltip tooltip) {
        this.tooltip = tooltip;
        return (T)this;
    }

    public T setTooltip(String text) {
        this.tooltip = new UITooltip(text);
        return (T)this;
    }

    public boolean isInsideBounds(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        return x >= this.screenX() && x <= this.screenX() + this.width && y >= this.screenY() && y <= this.screenY() + this.height;
    }

    public UIComponent getComponentAt(int x, int y) {
        return this.isInsideBounds(x, y) && !this.isDisabled() && this.isVisible() ? this : null;
    }

    public int componentX(int x) {
        return x - this.screenX();
    }

    public int componentY(int y) {
        return y - this.screenY();
    }

    public int containerX() {
        return this.parent == null ? this.x : this.parent.componentX(this);
    }

    public int containerY() {
        return this.parent == null ? this.y : this.parent.componentY(this);
    }

    public int screenX() {
        int x = this.containerX();
        if (this.parent != null) {
            x += this.parent.screenX();
            if (this.parent instanceof IScrollable) {
                x += ((IScrollable)((Object)this.parent)).getOffsetX();
            }
        }
        return x;
    }

    public int screenY() {
        int y = this.containerY();
        if (this.parent != null) {
            y += this.parent.screenY();
            if (this.parent instanceof IScrollable) {
                y += ((IScrollable)((Object)this.parent)).getOffsetY();
            }
        }
        return y;
    }

    public void draw(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible()) {
            return;
        }
        renderer.currentComponent = this;
        this.drawBackground(renderer, mouseX, mouseY, partialTick);
        renderer.next();
        renderer.currentComponent = this;
        this.drawForeground(renderer, mouseX, mouseY, partialTick);
        renderer.next();
    }

    public String toString() {
        return (this.name == null ? this.getClass().getSimpleName() : this.name) + " : [" + this.getPropertyString() + "]";
    }

    public String getPropertyString() {
        return "size=" + this.width + "," + this.height + " | position=" + this.x + "," + this.y + " | container=" + this.containerX() + "," + this.containerY() + " | screen=" + this.screenX() + "," + this.screenY();
    }

    public abstract void drawBackground(GuiRenderer var1, int var2, int var3, float var4);

    public abstract void drawForeground(GuiRenderer var1, int var2, int var3, float var4);
}

