/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component;

import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.event.KeyboardEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.inventory.InventoryEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class UISlot
extends UIComponent<UISlot> {
    public static boolean buttonRelased = true;
    private GuiIcon icon = new GuiIcon(209, 30, 18, 18);
    private GuiIcon iconLeft = new GuiIcon(209, 30, 1, 18);
    private GuiIcon iconTop = new GuiIcon(209, 30, 18, 1);
    protected MalisisSlot slot;

    public UISlot(MalisisSlot slot) {
        this.slot = slot;
        this.width = 18;
        this.height = 18;
        slot.register(this);
    }

    public UISlot() {
        this(null);
    }

    @Override
    public void setHovered(boolean hovered) {
        super.setHovered(hovered);
        this.updateTooltip();
        if (hovered && MalisisGui.currentGui().getInventoryContainer().isDraggingItemStack() && MalisisGui.currentGui().getInventoryContainer().getDraggedItemstack(this.slot) == null) {
            MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_ADD_SLOT, this.slot, 0);
        }
    }

    protected void updateTooltip() {
        if (this.slot.getItemStack() == null) {
            this.tooltip = null;
            return;
        }
        List lines = this.slot.getItemStack().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        lines.set(0, this.slot.getItemStack().func_77953_t().field_77937_e + (String)lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            lines.set(i, EnumChatFormatting.GRAY + (String)lines.get(i));
        }
        this.tooltip = new UITooltip().setText(lines);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiElement(18, 18);
        renderer.drawShape(shape, this.icon);
        renderer.next();
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        MalisisInventoryContainer container = MalisisGui.currentGui().getInventoryContainer();
        if (container == null) {
            return;
        }
        ItemStack itemStack = this.slot.getItemStack() != null ? this.slot.getItemStack().func_77946_l() : null;
        ItemStack draggedItemStack = container.getDraggedItemstack(this.slot);
        EnumChatFormatting format = null;
        if (itemStack == null) {
            itemStack = draggedItemStack;
        } else if (draggedItemStack != null) {
            itemStack.field_77994_a += draggedItemStack.field_77994_a;
            if (itemStack.field_77994_a == itemStack.func_77976_d()) {
                format = EnumChatFormatting.YELLOW;
            }
        }
        if (itemStack != null) {
            renderer.drawItemStack(itemStack, this.screenX() + 1, this.screenY() + 1, format);
        }
        if (this.hovered || draggedItemStack != null) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glShadeModel((int)7425);
            RenderParameters rp = new RenderParameters();
            rp.colorMultiplier.set(0xFFFFFF);
            rp.alpha.set(80);
            rp.useTexture.set(false);
            Shape shape = ShapePreset.GuiElement(16, 16).translate(1.0f, 1.0f, 100.0f);
            renderer.drawShape(shape, rp);
            renderer.next();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
        Shape shape = ShapePreset.GuiElement(1, 18).translate(0.0f, 0.0f, 50.0f);
        renderer.drawShape(shape, this.iconLeft);
        shape = ShapePreset.GuiElement(18, 1).translate(0.0f, 0.0f, 50.0f);
        renderer.drawShape(shape, this.iconTop);
    }

    @Subscribe
    public void clickSlot(MouseEvent.ButtonStateEvent event) {
        if (event instanceof MouseEvent.DoubleClick) {
            return;
        }
        MalisisInventoryContainer container = MalisisGui.currentGui().getInventoryContainer();
        MalisisInventoryContainer.ActionType action = null;
        if (container.getPickedItemStack() == null == event instanceof MouseEvent.Press && buttonRelased) {
            if (event.getButton() == MouseButton.LEFT) {
                MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.SHIFT_LEFT_CLICK : MalisisInventoryContainer.ActionType.LEFT_CLICK;
            }
            if (event.getButton() == MouseButton.RIGHT) {
                MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.SHIFT_RIGHT_CLICK : MalisisInventoryContainer.ActionType.RIGHT_CLICK;
            }
            if (event.getButtonCode() == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() + 100) {
                action = MalisisInventoryContainer.ActionType.PICKBLOCK;
            }
            buttonRelased = false;
        } else if (container.getPickedItemStack() != null && event instanceof MouseEvent.Press && !container.isDraggingItemStack()) {
            if (event.getButton() == MouseButton.LEFT) {
                MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146271_m() ? MalisisInventoryContainer.ActionType.DRAG_START_PICKUP : MalisisInventoryContainer.ActionType.DRAG_START_LEFT_CLICK;
            }
            if (event.getButton() == MouseButton.RIGHT) {
                action = MalisisInventoryContainer.ActionType.DRAG_START_RIGHT_CLICK;
            }
        }
        if (event instanceof MouseEvent.Release) {
            buttonRelased = true;
        }
        MalisisGui.sendAction(action, this.slot, event.getButtonCode());
    }

    @Subscribe
    public void doubleClick(MouseEvent.DoubleClick event) {
        MalisisInventoryContainer.ActionType action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.DOUBLE_SHIFT_LEFT_CLICK : MalisisInventoryContainer.ActionType.DOUBLE_LEFT_CLICK;
        MalisisGui.sendAction(action, this.slot, event.getButtonCode());
        buttonRelased = false;
    }

    @Subscribe
    public void onKeyTyped(KeyboardEvent event) {
        if (!this.hovered) {
            return;
        }
        MalisisInventoryContainer.ActionType action = null;
        int code = event.getKeyCode();
        if (event.getKeyCode() == Minecraft.func_71410_x().field_71474_y.field_74316_C.func_151463_i()) {
            MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.DROP_SLOT_STACK : MalisisInventoryContainer.ActionType.DROP_SLOT_ONE;
        }
        if (event.getKeyCode() == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i()) {
            action = MalisisInventoryContainer.ActionType.PICKBLOCK;
        }
        if (event.getKeyCode() >= 2 && event.getKeyCode() <= 10) {
            action = MalisisInventoryContainer.ActionType.HOTBAR;
            code -= 2;
        }
        MalisisGui.sendAction(action, this.slot, code);
    }

    @Subscribe
    public void onSlotChanged(InventoryEvent.SlotChanged event) {
        if (event.getSlot() != this.slot) {
            return;
        }
        this.updateTooltip();
    }
}

