/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.event.KeyboardEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import org.lwjgl.opengl.GL11;

public class UIContainer<T extends UIContainer>
extends UIComponent<T> {
    protected final List<UIComponent> components;
    protected int horizontalPadding;
    protected int verticalPadding;
    public boolean clipContent = true;
    private int backgroundColor = 0x404040;

    public UIContainer(String title, int width, int height) {
        this.setSize(width, height);
        this.components = new LinkedList<UIComponent>();
        if (title != null && !title.equals("")) {
            this.add(new UILabel(title));
        }
    }

    public UIContainer(int width, int height) {
        this(null, width, height);
    }

    public UIContainer() {
        this(null, 16, 16);
    }

    @Override
    public T setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            for (UIComponent c : this.components) {
                c.setHovered(false);
                c.setFocused(false);
            }
        }
        return (T)this;
    }

    @Override
    public T setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (disabled) {
            for (UIComponent c : this.components) {
                c.setHovered(false);
                c.setFocused(false);
            }
        }
        return (T)this;
    }

    public void setPadding(int horizontal, int vertical) {
        this.horizontalPadding = horizontal;
        this.verticalPadding = vertical;
    }

    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public int componentX(UIComponent component) {
        int x = component.getX();
        x = Anchor.horizontal(component.getAnchor()) == Anchor.CENTER ? (x += (this.width - component.getWidth()) / 2) : (Anchor.horizontal(component.getAnchor()) == Anchor.RIGHT ? (x += this.width - component.getWidth() - this.getHorizontalPadding()) : (x += this.getHorizontalPadding()));
        return x;
    }

    public int componentY(UIComponent component) {
        int y = component.getY();
        y = Anchor.vertical(component.getAnchor()) == Anchor.MIDDLE ? (y += (this.height - component.getHeight()) / 2) : (Anchor.vertical(component.getAnchor()) == Anchor.BOTTOM ? (y += this.height - component.getHeight() - this.getVerticalPadding()) : (y += this.getVerticalPadding()));
        return y;
    }

    public UIContainer setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void onContentUpdate() {
    }

    public ClipArea getClipArea() {
        return new ClipArea(this);
    }

    public void add(UIComponent component) {
        this.components.add(component);
        component.setParent(this);
        if (component.getZIndex() == Integer.MIN_VALUE) {
            component.setZIndex(this.zIndex);
        }
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.backgroundColor == 0x404040) {
            return;
        }
        GL11.glDisable((int)3553);
        Shape s = ShapePreset.GuiXYResizable(this.width, this.height, 0, 0);
        RenderParameters rp = new RenderParameters();
        rp.colorMultiplier.set(this.backgroundColor);
        renderer.drawShape(s, rp);
        renderer.next();
        GL11.glEnable((int)3553);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        ClipArea area = this.getClipArea();
        renderer.startClipping(area);
        for (UIComponent c : this.components) {
            c.draw(renderer, mouseX, mouseY, partialTick);
        }
        renderer.endClipping(area);
    }

    @Override
    public boolean fireKeyboardEvent(KeyboardEvent event) {
        for (UIComponent c : this.components) {
            c.fireKeyboardEvent(event);
        }
        return true;
    }

    @Override
    public UIComponent getComponentAt(int x, int y) {
        ArrayList<UIComponent> list = new ArrayList<UIComponent>();
        for (UIComponent c : this.components) {
            UIComponent component = c.getComponentAt(x, y);
            if (component == null) continue;
            list.add(component);
        }
        if (list.size() == 0) {
            return super.getComponentAt(x, y);
        }
        UIComponent component = null;
        for (UIComponent c : list) {
            if (component != null && component.getZIndex() > c.getZIndex()) continue;
            component = c;
        }
        return component;
    }
}

