/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;

public class UILabel
extends UIComponent<UILabel> {
    protected String text;
    protected int color = 0x404040;
    protected boolean drawShadow;
    protected boolean autoWidth = true;
    protected int textWidth;
    protected int textHeight;

    public UILabel(String text, int width) {
        this.setText(text);
        this.setSize(0);
    }

    public UILabel() {
        this(null, 0);
    }

    public UILabel(String text) {
        this(text, 0);
    }

    public UILabel setText(String text) {
        this.text = text;
        this.textWidth = GuiRenderer.getStringWidth(text);
        this.textHeight = GuiRenderer.FONT_HEIGHT;
        if (this.autoWidth) {
            this.setSize(0);
        }
        return this;
    }

    public String getText() {
        return this.text;
    }

    public UILabel setSize(int width) {
        this.autoWidth = width <= 0;
        this.width = this.autoWidth ? this.textWidth : width;
        this.height = this.textHeight;
        return this;
    }

    @Override
    public UILabel setSize(int width, int height) {
        return this.setSize(width);
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.parent != null) {
            this.parent.setFocused(focused);
        }
    }

    public UILabel setDrawShadow(boolean drawShadow) {
        this.drawShadow = drawShadow;
        return this;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.drawText(this.text, this.color, this.drawShadow);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[ text=" + this.text + ", color=0x" + Integer.toHexString(this.color) + ", " + this.getPropertyString() + " ]";
    }
}

