/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.minecraft.util.StatCollector;

public class UIMultiLineLabel
extends UILabel {
    protected String[] lines;
    protected boolean autoHeight;

    public UIMultiLineLabel(int width, int height, String ... text) {
        this.setText(text);
        this.setSize(width, height);
    }

    public UIMultiLineLabel() {
        this(0, 0, new String[0]);
    }

    public UIMultiLineLabel(String ... text) {
        this(0, 0, text);
    }

    @Override
    public UIMultiLineLabel setText(String text) {
        return this.setText(new String[]{text});
    }

    public UIMultiLineLabel setText(String ... text) {
        this.lines = text;
        this.textWidth = GuiRenderer.getMaxStringWidth(text);
        this.textHeight = (GuiRenderer.FONT_HEIGHT + 1) * text.length;
        this.setSize(this.autoWidth ? 0 : this.width, this.autoHeight ? 0 : this.height);
        return this;
    }

    @Override
    public UILabel setSize(int width) {
        return this.setSize(width, this.textHeight);
    }

    @Override
    public UILabel setSize(int width, int height) {
        this.autoWidth = width <= 0;
        this.autoHeight = height <= 0;
        this.width = this.autoWidth ? this.textWidth : width;
        this.height = this.autoHeight ? this.textHeight : height;
        return this;
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int i = 0;
        for (String line : this.lines) {
            List<String> lines = GuiRenderer.wrapText(StatCollector.func_74838_a((String)line), this.width);
            for (String str : lines) {
                renderer.drawText(str, 0, (GuiRenderer.FONT_HEIGHT + 1) * i++, this.color, this.drawShadow);
            }
        }
    }
}

