/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;

public class UIProgressBar
extends UIComponent<UIProgressBar> {
    private GuiIcon barIcon = new GuiIcon(246, 0, 22, 16);
    private GuiIcon barFilledIcon = this.barIcon.offsetCopy(0, 16);
    protected float progress = 0.0f;
    protected boolean reversed = false;

    public UIProgressBar() {
        this.width = 22;
        this.height = 16;
    }

    public float getProgress() {
        return this.progress;
    }

    public UIProgressBar setReversed() {
        this.barIcon = this.barIcon.getIconFlipped(true, false);
        this.barFilledIcon = this.barFilledIcon.getIconFlipped(true, false);
        this.reversed = true;
        return this;
    }

    public void setProgress(float progress) {
        if (progress < 0.0f) {
            progress = 0.0f;
        }
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        this.progress = progress;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiElement(22, 16);
        RenderParameters rp = new RenderParameters();
        rp.icon.set(this.barIcon);
        renderer.drawShape(shape, rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int width = (int)((float)this.width * this.progress);
        int xOffset = 0;
        GuiIcon icon = this.barFilledIcon.clippedCopy(0, 0, width, 16);
        if (this.reversed) {
            xOffset = this.width - width;
            icon = this.barFilledIcon.clippedCopy(width - 22, 0, -width, 16);
        }
        Shape shape = ShapePreset.GuiElement(width, 16);
        shape.translate(xOffset, 0.0f, 0.0f);
        renderer.drawShape(shape, icon);
    }
}

