/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.KeyboardEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public class UICheckBox
extends UIComponent<UICheckBox> {
    private GuiIcon checkboxBackground = new GuiIcon(242, 32, 10, 10);
    private GuiIcon checkboxBackgroundDisabled = this.checkboxBackground.offsetCopy(10, 0);
    private GuiIcon checkBoxDisabled = new GuiIcon(242, 42, 12, 10);
    private GuiIcon checkBoxChecked = this.checkBoxDisabled.offsetCopy(0, 10);
    private GuiIcon checkBoxHovered = this.checkBoxDisabled.offsetCopy(12, 0);
    private String label;
    private boolean checked;

    public UICheckBox(String label) {
        if (label != null && !label.equals("")) {
            this.label = label;
            this.width = GuiRenderer.getStringWidth(label);
        }
        this.width += 11;
        this.height = 10;
    }

    public UICheckBox() {
        this(null);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public UICheckBox setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiElement(10, 10).translate(1.0f, 0.0f, 0.0f);
        renderer.drawShape(shape, this.isDisabled() ? this.checkboxBackgroundDisabled : this.checkboxBackground);
        renderer.next();
        if (this.hovered) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glShadeModel((int)7425);
            RenderParameters rp = new RenderParameters();
            rp.colorMultiplier.set(0xFFFFFF);
            rp.alpha.set(80);
            rp.useTexture.set(false);
            shape = ShapePreset.GuiElement(8, 8).translate(2.0f, 1.0f, 0.0f);
            renderer.drawShape(shape, rp);
            renderer.next();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
        if (this.label != null) {
            renderer.drawText(this.label, 14, 2, 0x404040, false);
        }
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.checked) {
            GL11.glEnable((int)3042);
            GuiIcon icon = this.isDisabled() ? this.checkBoxDisabled : (this.isHovered() ? this.checkBoxHovered : this.checkBoxChecked);
            Shape shape = ShapePreset.GuiElement(12, 10);
            renderer.drawShape(shape, icon);
        }
    }

    @Subscribe
    public void onButtonRelease(MouseEvent.Release event) {
        if (event.getButton() == MouseButton.LEFT && this.fireEvent(new ComponentEvent.ValueChanged<UICheckBox, Boolean>(this, this.checked, !this.checked))) {
            this.checked = !this.checked;
        }
    }

    @Subscribe
    public void onKeyTyped(KeyboardEvent event) {
        if (!this.focused) {
            return;
        }
        if (event.getKeyCode() == 57 && this.fireEvent(new ComponentEvent.ValueChanged<UICheckBox, Boolean>(this, this.checked, !this.checked))) {
            this.checked = !this.checked;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[ text=" + this.label + ", checked=" + this.checked + ", " + this.getPropertyString() + " ]";
    }
}

