/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import org.lwjgl.opengl.GL11;

public class UIRadioButton
extends UIComponent<UIRadioButton> {
    private static HashMap<String, List<UIRadioButton>> radioButtons = new HashMap();
    private GuiIcon rbBackground = new GuiIcon(200, 54, 8, 8);
    private GuiIcon rbBackgroundDisabled = this.rbBackground.offsetCopy(0, 8);
    private GuiIcon rbDisabled = new GuiIcon(208, 54, 6, 6);
    private GuiIcon rbChecked = this.rbDisabled.offsetCopy(6, 0);
    private GuiIcon rbHovered = this.rbDisabled.offsetCopy(12, 0);
    private String name;
    private String label;
    private boolean selected;

    public UIRadioButton(String name, String label) {
        this.name = name;
        if (label != null && !label.equals("")) {
            this.label = label;
            this.width = GuiRenderer.getStringWidth(label);
        }
        this.width += 10;
        this.height = 11;
        UIRadioButton.addRadioButton(this);
    }

    public UIRadioButton(String name) {
        this(name, null);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected() {
        UIRadioButton rb = UIRadioButton.getSelected(this.name);
        if (rb != null) {
            rb.selected = false;
        }
        this.selected = true;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiElement(8, 8).translate(1.0f, 0.0f, 0.0f);
        renderer.drawShape(shape, this.isDisabled() ? this.rbBackgroundDisabled : this.rbBackground);
        renderer.next();
        if (this.hovered) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            renderer.enableBlending();
            RenderParameters rp = new RenderParameters();
            rp.colorMultiplier.set(0xFFFFFF);
            rp.alpha.set(80);
            rp.useTexture.set(false);
            shape = ShapePreset.GuiElement(6, 6).translate(2.0f, 2.0f, 0.0f);
            renderer.drawShape(shape, rp);
            renderer.next();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
        if (this.label != null) {
            renderer.drawText(this.label, 12, 0, 0x404040, false);
        }
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.selected) {
            GL11.glEnable((int)3042);
            GuiIcon icon = this.isDisabled() ? this.rbDisabled : (this.isHovered() ? this.rbHovered : this.rbChecked);
            Shape shape = ShapePreset.GuiElement(6, 6).translate(2.0f, 1.0f, 0.0f);
            renderer.drawShape(shape, icon);
        }
    }

    @Subscribe
    public void onButtonRelease(MouseEvent.Release event) {
        if (event.getButton() == MouseButton.LEFT && this.fireEvent(new ComponentEvent.ValueChanged<UIRadioButton, UIRadioButton>(this, this, UIRadioButton.getSelected(this.name)))) {
            this.setSelected();
        }
    }

    public static void addRadioButton(UIRadioButton rb) {
        List<UIRadioButton> listRb = radioButtons.get(rb.name);
        if (listRb == null) {
            listRb = new ArrayList<UIRadioButton>();
        }
        listRb.add(rb);
        radioButtons.put(rb.name, listRb);
    }

    public static UIRadioButton getSelected(String name) {
        List<UIRadioButton> listRb = radioButtons.get(name);
        if (listRb == null) {
            return null;
        }
        for (UIRadioButton rb : listRb) {
            if (!rb.selected) continue;
            return rb;
        }
        return null;
    }
}

