/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.interaction.IScrollable;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.gui.GuiScreen;

public class UIScrollBar
extends UIComponent {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int SCROLL_THICKNESS = 10;
    public static final int SCROLLER_HEIGHT = 15;
    private int type;
    public IScrollable scrollable;
    public int length;
    public int scrollableLength;
    public float offset;
    public GuiIcon[] icons = new GuiIcon[]{new GuiIcon(215, 0, 1, 1), new GuiIcon(220, 0, 1, 1), new GuiIcon(229, 0, 1, 1), new GuiIcon(215, 1, 1, 1), new GuiIcon(220, 1, 1, 1), new GuiIcon(229, 1, 1, 1), new GuiIcon(215, 14, 1, 1), new GuiIcon(220, 14, 1, 1), new GuiIcon(229, 14, 1, 1)};
    public GuiIcon[] disabledIcons = new GuiIcon[]{this.icons[0].offsetCopy(0, 15), this.icons[1].offsetCopy(0, 15), this.icons[2].offsetCopy(0, 15), this.icons[3].offsetCopy(0, 15), this.icons[4].offsetCopy(0, 15), this.icons[5].offsetCopy(0, 15), this.icons[6].offsetCopy(0, 15), this.icons[7].offsetCopy(0, 15), this.icons[8].offsetCopy(0, 15)};
    public GuiIcon verticalIcon = new GuiIcon(230, 0, 8, 15);
    public GuiIcon verticalDisabledIcon = this.verticalIcon.offsetCopy(8, 0);
    public GuiIcon horizontalIcon = new GuiIcon(230, 15, 15, 8);
    public GuiIcon horizontalDisabledIcon = this.horizontalIcon.offsetCopy(0, 8);

    public <T extends UIContainer> UIScrollBar(T scrollable, int length, int type) {
        this.setParent(scrollable);
        this.scrollable = (IScrollable)((Object)scrollable);
        this.type = type;
        this.length = length;
        if (type == 1) {
            this.width = length;
            this.height = 10;
        } else {
            this.width = 10;
            this.height = length;
        }
    }

    public UIComponent setPosition(int x, int y, int anchor) {
        this.x = x;
        this.y = y;
        this.anchor = anchor;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public UIScrollBar setLength(int length) {
        this.length = length;
        if (this.type == 1) {
            this.width = length;
        } else {
            this.height = length;
        }
        this.offset = Math.max(0.0f, Math.min(this.offset, (float)(length - 15 - 2)));
        return this;
    }

    public void setScrollableLength(int length) {
        this.scrollableLength = length;
        this.disabled = this.scrollableLength <= this.length;
    }

    public void scrollTo(float offset) {
        if (this.isDisabled()) {
            return;
        }
        if (offset < 0.0f) {
            offset = 0.0f;
        }
        if (offset > 1.0f) {
            offset = 1.0f;
        }
        this.offset = offset;
        int amount = (int)((float)(this.scrollableLength - this.length) * offset);
        if (this.type == 1) {
            this.scrollable.setOffsetX(amount);
        } else {
            this.scrollable.setOffsetY(amount);
        }
    }

    public void scrollBy(float amount) {
        this.scrollTo(this.offset + (amount *= -1.0f / (float)(this.scrollableLength - this.length)));
    }

    @Subscribe
    public void onClick(MouseEvent.Press event) {
        if (event.getButton() != MouseButton.LEFT) {
            return;
        }
        int l = this.length - 15 - 2;
        int pos = this.type == 1 ? this.componentX(event.getX()) : this.componentY(event.getY());
        pos = Math.max(0, Math.min(pos - 7, l));
        this.scrollTo((float)pos / (float)l);
    }

    @Subscribe
    public void onScrollWheel(MouseEvent.ScrollWheel event) {
        this.scrollBy(event.getDelta() * (GuiScreen.func_146271_m() ? 15 : 5));
    }

    @Subscribe
    public void onDrag(MouseEvent.Drag event) {
        if (event.getButton() != MouseButton.LEFT) {
            return;
        }
        int l = this.length - 15 - 2;
        int pos = this.type == 1 ? this.componentX(event.getX()) : this.componentY(event.getY());
        pos = Math.max(0, Math.min(pos - 7, l));
        this.scrollTo((float)pos / (float)l);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiXYResizable(this.width, this.height, 1, 1);
        renderer.drawShape(shape, this.isDisabled() ? this.disabledIcons : this.icons);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int h;
        int w;
        GuiIcon icon;
        int ox = 0;
        int oy = 0;
        int l = this.length - 15 - 2;
        if (this.type == 1) {
            icon = this.isDisabled() ? this.horizontalDisabledIcon : this.horizontalIcon;
            w = 15;
            h = 8;
            ox = (int)(this.offset * (float)l);
        } else {
            icon = this.isDisabled() ? this.verticalDisabledIcon : this.verticalIcon;
            w = 8;
            h = 15;
            oy = (int)(this.offset * (float)l);
        }
        Shape shape = ShapePreset.GuiElement(w, h);
        shape.translate(1.0f, 1.0f, 0.0f).translate(ox, oy, 0.0f);
        renderer.drawShape(shape, icon);
    }
}

