/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;

public class UISlider
extends UIComponent<UISlider> {
    public static int SLIDER_WIDTH = 8;
    public static GuiIcon[] iconBackground = new GuiIcon[]{new GuiIcon(0, 0, 5, 20), new GuiIcon(5, 0, 15, 20), new GuiIcon(195, 0, 5, 20)};
    public static GuiIcon sliderIcon = new GuiIcon(227, 46, 8, 20);
    private String label;
    private float minValue;
    private float maxValue;
    private float value;
    private float offset;

    public UISlider(int width, float min, float max, String label) {
        this.height = 20;
        this.width = width;
        this.minValue = min;
        this.maxValue = max;
        this.label = label;
    }

    public UISlider(int width, float min, float max) {
        this(width, min, max, null);
    }

    @Subscribe
    public void onClick(MouseEvent.Press event) {
        if (event.getButton() != MouseButton.LEFT) {
            return;
        }
        int l = this.width - SLIDER_WIDTH;
        int pos = this.componentX(event.getX());
        pos = Math.max(0, Math.min(pos - SLIDER_WIDTH / 2, l));
        this.slideTo((float)pos / (float)l);
    }

    @Subscribe
    public void onScrollWheel(MouseEvent.ScrollWheel event) {
        if (this.isFocused()) {
            this.slideBy(event.getDelta());
        }
    }

    @Subscribe
    public void onDrag(MouseEvent.Drag event) {
        if (event.getButton() != MouseButton.LEFT) {
            return;
        }
        int l = this.width - SLIDER_WIDTH;
        int pos = this.componentX(event.getX());
        pos = Math.max(0, Math.min(pos - SLIDER_WIDTH / 2, l));
        this.slideTo((float)pos / (float)l);
    }

    public void slideTo(float offset) {
        if (this.isDisabled()) {
            return;
        }
        if (offset < 0.0f) {
            offset = 0.0f;
        }
        if (offset > 1.0f) {
            offset = 1.0f;
        }
        this.offset = offset;
        float oldValue = this.value;
        float newValue = this.minValue + (this.maxValue - this.minValue) * offset;
        if (this.fireEvent(new ComponentEvent.ValueChanged<UISlider, Float>(this, Float.valueOf(oldValue), Float.valueOf(newValue)))) {
            this.value = newValue;
        }
    }

    public void slideBy(float amount) {
        this.slideTo(this.offset + (amount *= 0.05f));
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiXResizable(this.width, 20);
        renderer.drawShape(shape, iconBackground);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.zIndex = 0;
        int ox = (int)(this.offset * (float)(this.width - SLIDER_WIDTH));
        Shape shape = ShapePreset.GuiElement(8, 20);
        shape.translate(ox, 0.0f, 0.0f);
        renderer.drawShape(shape, sliderIcon);
        renderer.next();
        if (this.label != null) {
            String str = String.format(this.label, Float.valueOf(this.value));
            int x = (this.width - GuiRenderer.getStringWidth(str)) / 2;
            int y = 6;
            renderer.drawText(str, x, y, this.isHovered() ? 0xFFFFA0 : 0xFFFFFF, true);
        }
    }
}

