/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.KeyboardEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.opengl.GL11;

public class UITextField
extends UIComponent<UITextField> {
    public static GuiIcon[] iconTextfield = new GuiIcon[]{new GuiIcon(200, 30, 3, 12), new GuiIcon(203, 30, 3, 12), new GuiIcon(206, 30, 3, 12)};
    public static GuiIcon[] iconTextfieldDisabled = new GuiIcon[]{iconTextfield[0].offsetCopy(0, 12), iconTextfield[1].offsetCopy(0, 12), iconTextfield[2].offsetCopy(0, 12)};
    private StringBuilder text = new StringBuilder();
    private int cursorPosition;
    private int selectionPosition = -1;
    private int charOffset = 0;
    private long startTimer;
    private Pattern filter;
    private boolean selectAllOnRelease = false;
    protected boolean autoSelectOnFocus = false;
    private int textColor = 0xFFFFFF;

    public UITextField(int width, String text) {
        this.width = width;
        this.height = 12;
        if (text != null) {
            this.text.append(text);
        }
        iconTextfield = new GuiIcon[]{new GuiIcon(200, 30, 3, 12), new GuiIcon(203, 30, 3, 12), new GuiIcon(206, 30, 3, 12)};
    }

    public UITextField(int width) {
        this(width, null);
    }

    private int clamp(int pos) {
        return Math.max(0, Math.min(pos, this.text.length()));
    }

    private int cursorPositionFromX(int x) {
        int pos = 0;
        int width = 0;
        for (int i = this.charOffset; i < this.text.length(); ++i) {
            int w = GuiRenderer.getCharWidth(this.text.charAt(i));
            if ((float)width + (float)w / 2.0f > (float)x) {
                return pos + this.charOffset;
            }
            width += w;
            ++pos;
        }
        return pos + this.charOffset;
    }

    public void addText(String text) {
        if (this.selectionPosition != -1) {
            this.deleteSelectedText();
        }
        String oldValue = this.text.toString();
        StringBuilder temp = new StringBuilder(oldValue);
        temp.insert(this.cursorPosition, text);
        String newValue = temp.toString();
        if (!this.validateText(temp.toString())) {
            return;
        }
        if (!this.fireEvent(new ComponentEvent.ValueChanged<UITextField, String>(this, oldValue, newValue))) {
            return;
        }
        this.text.insert(this.cursorPosition, text);
        this.setCursorPosition(this.cursorPosition + text.length());
    }

    private int stringWidth(int start, int end) {
        if (end <= start) {
            return 0;
        }
        return GuiRenderer.getStringWidth(this.text.substring(this.clamp(start), this.clamp(end)));
    }

    private boolean validateText(String text) {
        if (this.filter == null) {
            return true;
        }
        Matcher matcher = this.filter.matcher(text);
        return matcher.matches();
    }

    public String getText() {
        return this.text.toString();
    }

    public void setText(String text) {
        if (!this.validateText(text)) {
            return;
        }
        this.text.setLength(0);
        this.text.append(text);
        this.unselectText();
        if (this.focused) {
            this.jumpToEnd();
        }
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        if (!this.focused) {
            this.selectAllOnRelease = true;
        } else {
            this.unselectText();
        }
        super.setFocused(focused);
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = this.clamp(position);
        while (this.stringWidth(this.charOffset, this.cursorPosition) > this.width - 3) {
            ++this.charOffset;
        }
        if (this.charOffset > this.cursorPosition) {
            this.charOffset = position;
        }
        this.startTimer = System.currentTimeMillis();
    }

    public UITextField setTextColor(int color) {
        this.textColor = color;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public UITextField setFilter(String regex) {
        this.filter = regex == null || regex.length() == 0 ? null : Pattern.compile(regex);
        return this;
    }

    public UITextField setAutoSelectOnFocus(boolean auto) {
        this.autoSelectOnFocus = auto;
        return this;
    }

    public String getSelectedText() {
        if (this.selectionPosition == -1) {
            return "";
        }
        int start = Math.min(this.selectionPosition, this.cursorPosition);
        int end = Math.max(this.selectionPosition, this.cursorPosition);
        return this.text.substring(start, end);
    }

    public void deleteSelectedText() {
        int start = Math.min(this.selectionPosition, this.cursorPosition);
        int end = Math.max(this.selectionPosition, this.cursorPosition);
        this.text.delete(start, end);
        this.unselectText();
        this.setCursorPosition(start);
    }

    public void unselectText() {
        this.selectionPosition = -1;
    }

    public void deleteFromCursor(int amount) {
        if (this.text.length() == 0) {
            return;
        }
        if (this.selectionPosition == -1) {
            this.selectionPosition = this.cursorPosition + amount;
        }
        this.deleteSelectedText();
    }

    public void deleteWords(int amount) {
        this.deleteFromCursor(this.nextSpacePosition(amount < 0));
    }

    public int nextSpacePosition(boolean backwards) {
        int pos = this.cursorPosition + (backwards ? -1 : 1);
        if (pos < 0 || pos > this.text.length()) {
            return 0;
        }
        if (this.text.charAt(pos) == ' ') {
            --pos;
        }
        while (pos > 0 && pos < this.text.length()) {
            if (this.text.charAt(pos) == ' ') {
                return pos + 1 - this.cursorPosition;
            }
            pos += backwards ? -1 : 1;
        }
        return pos - this.cursorPosition;
    }

    public void moveCursorBy(int amount) {
        if (GuiScreen.func_146272_n()) {
            this.setSelectionPosition(this.cursorPosition);
        } else {
            this.unselectText();
        }
        this.setCursorPosition(this.cursorPosition + amount);
    }

    public void jumpToBegining() {
        if (GuiScreen.func_146272_n()) {
            this.setSelectionPosition(this.cursorPosition);
        } else {
            this.unselectText();
        }
        this.setCursorPosition(0);
    }

    public void jumpToEnd() {
        if (GuiScreen.func_146272_n()) {
            this.setSelectionPosition(this.cursorPosition);
        } else {
            this.unselectText();
        }
        this.setCursorPosition(this.text.length());
    }

    public void setSelectionPosition(int pos) {
        if (this.selectionPosition == -1) {
            this.selectionPosition = this.cursorPosition;
        }
        this.setCursorPosition(pos);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiXResizable(this.width, this.height, 3);
        renderer.drawShape(shape, this.isDisabled() ? iconTextfieldDisabled : iconTextfield);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.text.length() != 0) {
            this.drawText(renderer);
        }
        if (this.selectionPosition != -1 && this.selectionPosition != this.cursorPosition) {
            this.drawSelectionBox(renderer);
        }
        if (this.focused) {
            this.drawCursor(renderer);
        }
    }

    public void drawText(GuiRenderer renderer) {
        int end = this.text.length();
        while (this.stringWidth(this.charOffset, end) > this.width - 2) {
            --end;
        }
        renderer.drawText(this.text.substring(this.charOffset, end), 2, 2, this.isDisabled() ? 0xAAAAAA : this.textColor, true);
    }

    public void drawCursor(GuiRenderer renderer) {
        long elaspedTime = this.startTimer - System.currentTimeMillis();
        if (elaspedTime / 500L % 2L != 0L) {
            return;
        }
        GL11.glDisable((int)3553);
        int offset = this.stringWidth(this.charOffset, this.cursorPosition);
        Shape shape = ShapePreset.GuiElement(1, 10);
        shape.translate(offset + 1, 1.0f, 0.0f);
        RenderParameters rp = new RenderParameters();
        rp.useTexture.set(false);
        rp.colorMultiplier.set(0xD0D0D0);
        renderer.drawShape(shape, rp);
        renderer.next();
        GL11.glEnable((int)3553);
    }

    public void drawSelectionBox(GuiRenderer renderer) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        int start = Math.max(Math.min(this.cursorPosition, this.selectionPosition), this.charOffset);
        int width = this.stringWidth(start, Math.max(this.cursorPosition, this.selectionPosition));
        start = this.stringWidth(this.charOffset, start);
        width = Math.min(this.width - start - 2, width);
        Shape shape = ShapePreset.GuiElement(width, 10);
        shape.translate(start + 1, 1.0f, 0.0f);
        RenderParameters rp = new RenderParameters();
        rp.useTexture.set(false);
        rp.colorMultiplier.set(255);
        renderer.drawShape(shape, rp);
        renderer.next();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    @Subscribe
    public void onClick(MouseEvent.Press event) {
        int pos = this.cursorPositionFromX(this.componentX(event.getX()));
        if (GuiScreen.func_146272_n()) {
            this.setSelectionPosition(pos);
        } else {
            this.unselectText();
            this.setCursorPosition(pos);
        }
    }

    @Subscribe
    public void onClick(MouseEvent.Release event) {
        if (!this.autoSelectOnFocus || !this.selectAllOnRelease) {
            return;
        }
        this.setCursorPosition(0);
        this.setSelectionPosition(this.text.length());
        this.selectAllOnRelease = false;
    }

    @Subscribe
    public void onDrag(MouseEvent.Drag event) {
        if (!this.focused || event.getButton() != MouseButton.LEFT) {
            return;
        }
        int pos = this.cursorPositionFromX(this.componentX(event.getX()));
        this.setSelectionPosition(pos);
        this.selectAllOnRelease = false;
    }

    @Subscribe
    public void keyTyped(KeyboardEvent event) {
        if (!this.focused) {
            return;
        }
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        if (keyCode == 1) {
            return;
        }
        event.cancel();
        if (this.handleCtrlKeyDown(keyCode)) {
            return;
        }
        switch (keyCode) {
            case 203: {
                this.moveCursorBy(-1);
                return;
            }
            case 205: {
                this.moveCursorBy(1);
                return;
            }
            case 199: {
                this.jumpToBegining();
                return;
            }
            case 207: {
                this.jumpToEnd();
                return;
            }
            case 14: {
                this.deleteFromCursor(-1);
                return;
            }
            case 211: {
                this.deleteFromCursor(1);
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)keyChar)) {
            this.addText(Character.toString(keyChar));
        }
    }

    private boolean handleCtrlKeyDown(int keyCode) {
        if (!GuiScreen.func_146271_m()) {
            return false;
        }
        switch (keyCode) {
            case 203: {
                this.moveCursorBy(this.nextSpacePosition(true));
                return true;
            }
            case 205: {
                this.moveCursorBy(this.nextSpacePosition(false));
                return true;
            }
            case 14: {
                this.deleteWords(-1);
                return true;
            }
            case 211: {
                this.deleteWords(1);
                return true;
            }
            case 30: {
                this.setCursorPosition(0);
                this.setSelectionPosition(this.text.length());
                return true;
            }
            case 46: {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return true;
            }
            case 47: {
                this.addText(GuiScreen.func_146277_j());
                return true;
            }
            case 45: {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                this.addText("");
                return true;
            }
        }
        return false;
    }
}

