/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.packet.OpenIventoryMessage;
import net.malisis.core.util.ItemUtils;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MalisisInventory
implements IInventory {
    protected IInventoryProvider inventoryProvider;
    protected MalisisSlot[] slots;
    protected int size;
    protected int slotMaxStackSize = 64;
    protected EventBus bus = new EventBus();

    public MalisisInventory(IInventoryProvider provider, int size) {
        this.inventoryProvider = provider;
        MalisisSlot[] slots = new MalisisSlot[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = new MalisisSlot(this, i);
        }
        this.setSlots(slots);
    }

    public MalisisInventory(IInventoryProvider provider, MalisisSlot[] slots) {
        this.inventoryProvider = provider;
        this.setSlots(slots);
    }

    public void setSlots(MalisisSlot[] slots) {
        this.size = slots.length;
        this.slots = slots;
        for (MalisisSlot slot : slots) {
            slot.setInventory(this);
        }
    }

    public void overrideSlot(MalisisSlot slot, int slotNumber) {
        if (slotNumber < 0 || slotNumber >= this.func_70302_i_()) {
            return;
        }
        this.slots[slotNumber] = slot;
    }

    public void register(Object object) {
        this.bus.register(object);
    }

    public MalisisSlot getSlot(int slotNumber) {
        if (slotNumber < 0 || slotNumber >= this.func_70302_i_()) {
            return null;
        }
        return this.slots[slotNumber];
    }

    public MalisisSlot[] getSlots() {
        return this.slots;
    }

    public ItemStack getItemStack(int slotNumber) {
        MalisisSlot slot = this.getSlot(slotNumber);
        return slot != null ? slot.getItemStack() : null;
    }

    public void setItemStack(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getSlot(slotNumber);
        if (slot == null) {
            return;
        }
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        slot.setItemStack(itemStack);
        slot.onSlotChanged();
    }

    public boolean itemValidForSlot(MalisisSlot slot, ItemStack itemStack) {
        return true;
    }

    public boolean func_94041_b(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getSlot(slotNumber);
        if (slot == null) {
            return false;
        }
        return slot.isItemValid(itemStack);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public int func_70297_j_() {
        return this.slotMaxStackSize;
    }

    public void setInventoryStackLimit(int limit) {
        this.slotMaxStackSize = limit;
    }

    public void onSlotChanged(MalisisSlot slot) {
        this.bus.post((Object)new InventoryEvent.SlotChanged(this, slot));
    }

    public void func_70295_k_() {
    }

    public ItemStack transferInto(ItemStack itemStack) {
        return this.transferInto(itemStack, false);
    }

    public ItemStack transferInto(ItemStack itemStack, boolean reversed) {
        int end;
        int start = reversed ? this.size - 1 : 0;
        if ((itemStack = this.transferInto(itemStack, false, start, end = reversed ? 0 : this.size - 1)) != null) {
            itemStack = this.transferInto(itemStack, true, start, end);
        }
        return itemStack;
    }

    protected ItemStack transferInto(ItemStack itemStack, boolean emptySlot, int start, int end) {
        int current = start;
        int step = 1;
        if (start > end) {
            step = -1;
            start = end;
            end = current;
        }
        while (itemStack != null && current >= start && current <= end) {
            ItemUtils.ItemStacksMerger ism;
            MalisisSlot slot = this.getSlot(current);
            if (slot.isItemValid(itemStack) && (emptySlot || slot.getItemStack() != null) && (ism = new ItemUtils.ItemStacksMerger(itemStack, slot.getItemStack())).merge(-1, slot.getSlotStackLimit())) {
                itemStack = ism.merge;
                slot.setItemStack(ism.into);
                slot.onSlotChanged();
            }
            current += step;
        }
        return itemStack;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound stackTag = nbttaglist.func_150305_b(i);
            int slotNumber = stackTag.func_74771_c("Slot") & 0xFF;
            MalisisSlot slot = this.getSlot(slotNumber);
            if (slot == null) continue;
            slot.setItemStack(ItemStack.func_77949_a((NBTTagCompound)stackTag));
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.getItemStack(i);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    public MalisisInventoryContainer open(EntityPlayerMP player) {
        if (this.inventoryProvider == null) {
            return null;
        }
        MalisisInventoryContainer c = new MalisisInventoryContainer(this, (EntityPlayer)player, 0);
        OpenIventoryMessage.send(this.inventoryProvider, player, c.field_75152_c);
        c.sendInventoryContent();
        this.func_70295_k_();
        this.bus.post((Object)new InventoryEvent.Open(this));
        return c;
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisInventoryContainer open(EntityClientPlayerMP player, int windowId) {
        MalisisGui gui;
        if (this.inventoryProvider == null) {
            return null;
        }
        MalisisInventoryContainer c = new MalisisInventoryContainer(this, (EntityPlayer)player, windowId);
        if (FMLCommonHandler.instance().getSide().isClient() && (gui = this.inventoryProvider.getGui(c)) != null) {
            gui.display();
        }
        this.func_70295_k_();
        this.bus.post((Object)new InventoryEvent.Open(this));
        return c;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
    }

    public ItemStack func_70298_a(int slot, int count) {
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public String func_145825_b() {
        return null;
    }

    @Deprecated
    public ItemStack func_70301_a(int slotNumber) {
        return this.getItemStack(slotNumber);
    }

    @Deprecated
    public void func_70299_a(int slotNumber, ItemStack itemStack) {
        this.setItemStack(slotNumber, itemStack);
    }
}

