/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.player.PlayerInventory;
import net.malisis.core.inventory.player.PlayerInventorySlot;
import net.malisis.core.packet.UpdateInventorySlotsMessage;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class MalisisInventoryContainer
extends Container {
    public static final int DRAG_TYPE_SPREAD = 0;
    public static final int DRAG_TYPE_ONE = 1;
    public static final int DRAG_TYPE_PICKUP = 2;
    protected EntityPlayer owner;
    protected MalisisInventory inventory;
    protected MalisisInventory playerInventory;
    protected HashMap<Integer, ItemStack> inventoryCache = new HashMap();
    protected HashMap<Integer, ItemStack> playerInventoryCache = new HashMap();
    protected ItemStack pickedItemStack;
    protected ItemStack pickedItemStackCache;
    protected int draggedAmount = 0;
    protected HashMap<Integer, ItemStack> draggedItemStacks = new HashMap();
    protected boolean draggedItemStackChanged = false;
    protected int dragType = -1;
    protected ItemStack lastShiftClicked;

    public MalisisInventoryContainer(MalisisInventory inventory, EntityPlayer player, int windowId) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            p.func_71128_l();
            p.func_71117_bO();
            windowId = p.field_71139_cq;
        }
        this.owner = player;
        this.field_75152_c = windowId;
        this.inventory = inventory;
        this.playerInventory = new PlayerInventory(player);
        this.owner.field_71070_bA = this;
    }

    public MalisisInventory getContainerInventory() {
        return this.inventory;
    }

    public MalisisInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public void setPickedItemStack(ItemStack itemStack) {
        this.pickedItemStack = itemStack;
        this.owner.field_71071_by.func_70437_b(itemStack);
    }

    public ItemStack getPickedItemStack() {
        return this.pickedItemStack;
    }

    public void setDraggedItems(HashMap<Integer, ItemStack> items) {
        this.draggedItemStacks = items;
    }

    public ItemStack getDraggedItemstack(MalisisSlot slot) {
        int slotNumber = slot instanceof PlayerInventorySlot ? slot.slotNumber + this.inventory.size : slot.slotNumber;
        return this.draggedItemStacks.get(slotNumber);
    }

    public boolean isDraggingItemStack() {
        return this.dragType != -1;
    }

    public boolean shouldEndDrag(int button) {
        if (!this.isDraggingItemStack()) {
            return false;
        }
        if (this.dragType == 1 || this.dragType == 0) {
            return this.dragType == button && this.draggedItemStacks.size() > 1;
        }
        return this.dragType == 2;
    }

    public boolean shouldResetDrag(int button) {
        if (!this.isDraggingItemStack()) {
            return false;
        }
        if (this.dragType == 0) {
            return button == 1 && this.draggedItemStacks.size() > 1;
        }
        if (this.dragType == 1) {
            return button == 0 && this.draggedItemStacks.size() > 1;
        }
        return this.dragType != 2;
    }

    public int getDragType() {
        return this.dragType;
    }

    public void sendInventoryContent() {
        if (!(this.owner instanceof EntityPlayerMP)) {
            MalisisCore.log.error("MalisisInventoryContainer tried to send inventory contents CLIENT side!.");
            return;
        }
        ArrayList<MalisisSlot> slots = new ArrayList<MalisisSlot>(Arrays.asList(this.inventory.getSlots()));
        UpdateInventorySlotsMessage.updateSlots(UpdateInventorySlotsMessage.SlotType.TYPE_INVENTORY, slots, (EntityPlayerMP)this.owner, this.field_75152_c);
    }

    public void func_75142_b() {
        this.detectAndSendChanges(UpdateInventorySlotsMessage.SlotType.TYPE_INVENTORY);
        this.detectAndSendChanges(UpdateInventorySlotsMessage.SlotType.TYPE_PLAYERINVENTORY);
        this.detectAndSendPickedItemStack();
        this.detectAndSendDraggedItems();
    }

    public void detectAndSendChanges(UpdateInventorySlotsMessage.SlotType type) {
        if (!(this.owner instanceof EntityPlayerMP)) {
            MalisisCore.log.error("MalisisInventoryContainer tried to send " + (Object)((Object)type) + " slots CLIENT side !.");
            return;
        }
        MalisisInventory inventory = type == UpdateInventorySlotsMessage.SlotType.TYPE_PLAYERINVENTORY ? this.playerInventory : this.inventory;
        HashMap<Integer, ItemStack> cache = type == UpdateInventorySlotsMessage.SlotType.TYPE_PLAYERINVENTORY ? this.playerInventoryCache : this.inventoryCache;
        ArrayList<MalisisSlot> changedSlots = new ArrayList<MalisisSlot>();
        for (MalisisSlot slot : inventory.getSlots()) {
            if (ItemStack.func_77989_b((ItemStack)slot.getItemStack(), (ItemStack)cache.get(slot.slotNumber))) continue;
            changedSlots.add(slot);
            cache.put(slot.slotNumber, slot.getItemStack() != null ? slot.getItemStack().func_77946_l() : null);
        }
        if (changedSlots.size() > 0) {
            UpdateInventorySlotsMessage.updateSlots(type, changedSlots, (EntityPlayerMP)this.owner, this.field_75152_c);
        }
    }

    public void detectAndSendPickedItemStack() {
        if (!(this.owner instanceof EntityPlayerMP)) {
            MalisisCore.log.error(" MalisisInventoryContainer tried to send picked itemStack CLIENT side !.");
            return;
        }
        if (ItemStack.func_77989_b((ItemStack)this.pickedItemStack, (ItemStack)this.pickedItemStackCache)) {
            return;
        }
        UpdateInventorySlotsMessage.updatePickedItemStack(this.pickedItemStack, (EntityPlayerMP)this.owner, this.field_75152_c);
        this.pickedItemStackCache = this.pickedItemStack != null ? this.pickedItemStack.func_77946_l() : null;
    }

    public void detectAndSendDraggedItems() {
        if (!(this.owner instanceof EntityPlayerMP)) {
            MalisisCore.log.error("MalisisInventoryContainer tried to send dragged itemStack CLIENT side !");
            return;
        }
        if (!this.draggedItemStackChanged) {
            return;
        }
        UpdateInventorySlotsMessage.updateDraggedItemStacks(this.draggedItemStacks, (EntityPlayerMP)this.owner, this.field_75152_c);
        this.draggedItemStackChanged = false;
    }

    public ItemStack handleAction(ActionType action, int slotNumber, int code, boolean isPlayerInv) {
        MalisisSlot slot;
        MalisisSlot malisisSlot = slot = isPlayerInv ? this.playerInventory.getSlot(slotNumber) : this.inventory.getSlot(slotNumber);
        if (slot == null) {
            MalisisCore.log.error("MalisisInventoryContainer try to handle an action for an wrong slotNumber.");
            return null;
        }
        if (action == ActionType.HOTBAR && code >= 0 && code < 9) {
            return this.handleHotbar(slot, code);
        }
        if (action == ActionType.DROP_SLOT_STACK || action == ActionType.DROP_SLOT_ONE) {
            return this.handleDropSlot(slot, action == ActionType.DROP_SLOT_STACK);
        }
        if (action.isDragAction()) {
            return this.handleDrag(action, slot);
        }
        this.resetDrag();
        if (action == ActionType.DROP_ONE || action == ActionType.DROP_STACK) {
            return this.handleDropPickedStack(action == ActionType.DROP_STACK);
        }
        if (action == ActionType.LEFT_CLICK || action == ActionType.RIGHT_CLICK) {
            return this.handleNormalClick(slot, action == ActionType.LEFT_CLICK);
        }
        if (action == ActionType.PICKBLOCK && this.owner.field_71075_bZ.field_75098_d) {
            return this.handlePickBlock(slot);
        }
        if (action == ActionType.SHIFT_LEFT_CLICK) {
            this.lastShiftClicked = slot.getItemStack();
            ItemStack itemStack = this.handleShiftClick(slot);
            if (itemStack != null) {
                this.lastShiftClicked = null;
            }
            return itemStack;
        }
        if (action == ActionType.DOUBLE_LEFT_CLICK || action == ActionType.DOUBLE_SHIFT_LEFT_CLICK) {
            return this.handleDoubleClick(slot, action == ActionType.DOUBLE_SHIFT_LEFT_CLICK);
        }
        return null;
    }

    private ItemStack handleDropPickedStack(boolean fullStack) {
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(this.pickedItemStack);
        iss.split(fullStack ? -1 : 1);
        this.owner.func_71019_a(iss.split, true);
        this.setPickedItemStack(iss.source);
        return iss.source;
    }

    private ItemStack handleNormalClick(MalisisSlot slot, boolean fullStack) {
        ItemStack slotStack = slot.getItemStack();
        if (this.pickedItemStack != null && !slot.isItemValid(this.pickedItemStack)) {
            return null;
        }
        if (this.pickedItemStack != null) {
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(this.pickedItemStack, slotStack);
            int amount = fullStack ? -1 : 1;
            if (ism.merge(amount, slot.getSlotStackLimit())) {
                slot.setItemStack(ism.into);
                this.setPickedItemStack(ism.merge);
            } else if (this.pickedItemStack.field_77994_a <= slot.getSlotStackLimit()) {
                slot.setItemStack(ism.merge);
                this.setPickedItemStack(ism.into);
            }
            if (ism.nbMerged != 0) {
                slot.onSlotChanged();
            }
            return ism.merge;
        }
        int amount = fullStack ? -1 : -2;
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(slotStack);
        iss.split(amount);
        slot.setItemStack(iss.source);
        this.setPickedItemStack(iss.split);
        if (iss.amount != 0) {
            slot.onPickupFromSlot(this.owner, iss.split);
        }
        return iss.split;
    }

    private ItemStack handleShiftClick(MalisisSlot slot) {
        if (slot.getItemStack() == null) {
            return null;
        }
        MalisisInventory targetInventory = slot instanceof PlayerInventorySlot ? this.inventory : this.playerInventory;
        ItemStack stackMoved = slot.getItemStack().func_77946_l();
        ItemStack itemStack = targetInventory.transferInto(slot.getItemStack());
        slot.setItemStack(itemStack);
        slot.onSlotChanged();
        stackMoved.field_77994_a = stackMoved.field_77994_a - (itemStack == null ? 0 : itemStack.field_77994_a);
        return itemStack;
    }

    private ItemStack handleHotbar(MalisisSlot slot, int num) {
        boolean fromPlayerInv = slot instanceof PlayerInventorySlot;
        MalisisSlot destSlot = this.playerInventory.getSlot(num);
        if (fromPlayerInv || slot.getItemStack() == null) {
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(destSlot.getItemStack(), slot.getItemStack());
            ism.merge(-1, slot.getSlotStackLimit());
            destSlot.setItemStack(ism.merge);
            destSlot.onSlotChanged();
            slot.setItemStack(ism.into);
            slot.onSlotChanged();
            return null;
        }
        ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(slot.getItemStack(), destSlot.getItemStack());
        ism.merge();
        destSlot.setItemStack(ism.into);
        destSlot.onSlotChanged();
        ItemStack itemStack = this.playerInventory.transferInto(ism.merge, false);
        slot.setItemStack(itemStack);
        slot.onSlotChanged();
        return destSlot.getItemStack();
    }

    private ItemStack handleDropSlot(MalisisSlot slot, boolean fullStack) {
        if (slot.getItemStack() == null) {
            return null;
        }
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(slot.getItemStack());
        iss.split(fullStack ? -1 : 1);
        slot.setItemStack(iss.source);
        this.owner.func_71019_a(iss.split, true);
        if (iss.amount != 0) {
            slot.onPickupFromSlot(this.owner, iss.split);
        }
        return iss.split;
    }

    private ItemStack handleDoubleClick(MalisisSlot slot, boolean shiftClick) {
        MalisisInventory inventory;
        MalisisInventory malisisInventory = inventory = slot instanceof PlayerInventorySlot ? this.playerInventory : this.inventory;
        if (!shiftClick && this.pickedItemStack != null) {
            for (int i = 0; this.pickedItemStack.field_77994_a < this.pickedItemStack.func_77976_d() && i < inventory.size; ++i) {
                MalisisSlot s = inventory.getSlot(i);
                ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(s.getItemStack(), this.pickedItemStack);
                ism.merge();
                s.setItemStack(ism.merge);
                s.onSlotChanged();
                this.pickedItemStack = ism.into;
            }
            this.setPickedItemStack(this.pickedItemStack);
        } else if (this.lastShiftClicked != null) {
            MalisisInventory targetInventory = slot instanceof PlayerInventorySlot ? this.inventory : this.playerInventory;
            for (MalisisSlot s : inventory.getSlots()) {
                if (s.getItemStack() == null || !ItemUtils.areItemStacksStackable(s.getItemStack(), this.lastShiftClicked)) continue;
                ItemStack itemStack = targetInventory.transferInto(s.getItemStack());
                s.setItemStack(itemStack);
                s.onSlotChanged();
                if (itemStack == null) continue;
                return this.pickedItemStack;
            }
        }
        this.lastShiftClicked = null;
        return this.pickedItemStack;
    }

    private ItemStack handlePickBlock(MalisisSlot slot) {
        if (slot.getItemStack() == null || this.pickedItemStack != null) {
            return null;
        }
        ItemStack itemStack = slot.getItemStack().func_77946_l();
        itemStack.field_77994_a = itemStack.func_77976_d();
        this.setPickedItemStack(itemStack);
        return itemStack;
    }

    private ItemStack handleDrag(ActionType action, MalisisSlot slot) {
        if (this.pickedItemStack == null) {
            return null;
        }
        if ((action == ActionType.DRAG_START_LEFT_CLICK || action == ActionType.DRAG_START_RIGHT_CLICK) && this.isDraggingItemStack()) {
            return null;
        }
        if (action == ActionType.DRAG_RESET) {
            this.resetDrag();
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_END && this.dragType == 2) {
            int size = this.pickedItemStack.field_77994_a;
            this.resetDrag();
            this.pickedItemStack.field_77994_a = size;
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_END) {
            int amountMerged = 0;
            HashMap<Integer, MalisisSlot> draggedSlots = this.getDraggedSlots();
            for (Map.Entry<Integer, ItemStack> entry : this.draggedItemStacks.entrySet()) {
                MalisisSlot s = draggedSlots.get(entry.getKey());
                if (!s.isItemValid(this.pickedItemStack)) continue;
                ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(entry.getValue(), s.getItemStack());
                ism.merge();
                amountMerged += ism.nbMerged;
                s.setItemStack(ism.into);
                s.onSlotChanged();
            }
            if (this.pickedItemStack.field_77994_a == 0) {
                this.setPickedItemStack(null);
            }
            this.resetDrag();
            if (this.pickedItemStack != null) {
                this.pickedItemStack.field_77994_a -= amountMerged;
            }
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_START_PICKUP) {
            this.dragType = 2;
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_ADD_SLOT && this.dragType == 2) {
            if (this.pickedItemStack.field_77994_a >= this.pickedItemStack.func_77976_d()) {
                return this.pickedItemStack;
            }
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(slot.getItemStack(), this.pickedItemStack);
            ism.merge();
            this.setPickedItemStack(ism.into);
            slot.setItemStack(ism.merge);
            slot.onSlotChanged();
            return this.pickedItemStack;
        }
        int slotNumber = slot instanceof PlayerInventorySlot ? slot.slotNumber + this.inventory.size : slot.slotNumber;
        this.draggedItemStacks.put(slotNumber, null);
        this.draggedItemStackChanged = true;
        if (action == ActionType.DRAG_START_LEFT_CLICK || action == ActionType.DRAG_START_RIGHT_CLICK) {
            this.draggedAmount = this.pickedItemStack.field_77994_a;
            this.dragType = action == ActionType.DRAG_START_LEFT_CLICK ? 0 : 1;
            return this.pickedItemStack;
        }
        if (this.draggedItemStacks.size() > this.draggedAmount) {
            return null;
        }
        int amountPerSlot = this.dragType == 0 ? Math.max(this.draggedAmount / this.draggedItemStacks.size(), 1) : 1;
        int amountTotal = 0;
        HashMap<Integer, MalisisSlot> draggedSlots = this.getDraggedSlots();
        for (Map.Entry<Integer, ItemStack> entry : this.draggedItemStacks.entrySet()) {
            if (!draggedSlots.get(entry.getKey()).isItemValid(this.pickedItemStack)) continue;
            ItemStack itemStack = this.pickedItemStack.func_77946_l();
            itemStack.field_77994_a = this.draggedAmount;
            ItemStack slotStack = draggedSlots.get(entry.getKey()).getItemStack();
            if (slotStack != null) {
                slotStack = slotStack.func_77946_l();
            }
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(itemStack, slotStack);
            ism.merge(amountPerSlot, draggedSlots.get(entry.getKey()).getSlotStackLimit());
            itemStack.field_77994_a = ism.nbMerged;
            amountTotal += ism.nbMerged;
            this.draggedItemStacks.put(entry.getKey(), itemStack);
        }
        this.pickedItemStack.field_77994_a = this.draggedAmount - amountTotal;
        return this.pickedItemStack;
    }

    private HashMap<Integer, MalisisSlot> getDraggedSlots() {
        HashMap<Integer, MalisisSlot> slots = new HashMap<Integer, MalisisSlot>();
        for (Map.Entry<Integer, ItemStack> entry : this.draggedItemStacks.entrySet()) {
            int slotNumber = entry.getKey();
            MalisisInventory inventory = this.inventory;
            if (slotNumber >= inventory.size) {
                inventory = this.playerInventory;
                slotNumber -= this.inventory.size;
            }
            slots.put(entry.getKey(), inventory.getSlot(slotNumber));
        }
        return slots;
    }

    private void resetDrag() {
        if (!this.isDraggingItemStack()) {
            return;
        }
        if (this.pickedItemStack != null) {
            this.pickedItemStack.field_77994_a = this.draggedAmount;
        }
        this.draggedItemStacks.clear();
        this.draggedAmount = 0;
        this.draggedItemStackChanged = true;
        this.dragType = -1;
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public static enum ActionType {
        LEFT_CLICK,
        RIGHT_CLICK,
        PICKBLOCK,
        SHIFT_LEFT_CLICK,
        SHIFT_RIGHT_CLICK,
        DOUBLE_LEFT_CLICK,
        DOUBLE_SHIFT_LEFT_CLICK,
        DRAG_START_LEFT_CLICK,
        DRAG_START_RIGHT_CLICK,
        DRAG_START_PICKUP,
        DRAG_ADD_SLOT,
        DRAG_END,
        DRAG_RESET,
        HOTBAR,
        DROP_ONE,
        DROP_STACK,
        DROP_SLOT_ONE,
        DROP_SLOT_STACK;


        public boolean isDragAction() {
            return this == DRAG_START_LEFT_CLICK || this == DRAG_START_RIGHT_CLICK || this == DRAG_START_PICKUP || this == DRAG_ADD_SLOT || this == DRAG_END || this == DRAG_RESET;
        }
    }
}

