/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import net.malisis.core.inventory.MalisisInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class MalisisSlot {
    private MalisisInventory inventory;
    private ItemStack itemStack;
    public int slotNumber;
    protected boolean isOutputSlot = false;

    public MalisisSlot(MalisisInventory inventory, ItemStack itemStack, int index) {
        this.inventory = inventory;
        this.slotNumber = index;
        this.itemStack = itemStack;
    }

    public MalisisSlot(MalisisInventory inventory, int index) {
        this(inventory, null, index);
    }

    public MalisisSlot(int index) {
        this(null, null, index);
    }

    public void register(Object object) {
        if (this.inventory != null) {
            this.inventory.register(object);
        }
    }

    public void setInventory(MalisisInventory inventory) {
        this.inventory = inventory;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setOutputSlot(boolean isOutput) {
        this.isOutputSlot = isOutput;
    }

    public boolean isItemValid(ItemStack itemStack) {
        if (this.isOutputSlot) {
            return false;
        }
        if (this.inventory == null) {
            return true;
        }
        return this.inventory.itemValidForSlot(this, itemStack);
    }

    public void onSlotChanged() {
        this.inventory.onSlotChanged(this);
    }

    public void onPickupFromSlot(EntityPlayer player, ItemStack itemStack) {
        this.onSlotChanged();
    }

    public int setItemStackSize(int stackSize) {
        if (this.itemStack == null) {
            return 0;
        }
        int start = this.itemStack.field_77994_a;
        if (stackSize <= 0) {
            this.itemStack = null;
            return start;
        }
        this.itemStack.field_77994_a = Math.min(stackSize, Math.min(this.itemStack.func_77976_d(), this.getSlotStackLimit()));
        return this.itemStack.field_77994_a - start;
    }

    public int addItemStackSize(int stackSize) {
        if (this.itemStack == null) {
            return 0;
        }
        return this.setItemStackSize(this.itemStack.field_77994_a + stackSize);
    }

    public int getSlotStackLimit() {
        if (this.inventory == null) {
            return 64;
        }
        return this.inventory.func_70297_j_();
    }

    public String toString() {
        return this.slotNumber + (this.inventory != null ? "/" + this.inventory.func_70302_i_() : "") + " > " + this.itemStack;
    }
}

