/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.packet.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;

public class InventoryActionMessage
implements IMessageHandler<Packet, IMessage> {
    public IMessage onMessage(Packet message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            return null;
        }
        Container c = ctx.getServerHandler().field_147369_b.field_71070_bA;
        if (message.windowId != c.field_75152_c || !(c instanceof MalisisInventoryContainer)) {
            return null;
        }
        MalisisInventoryContainer container = (MalisisInventoryContainer)c;
        container.handleAction(message.action, message.slotNumber, message.code, message.playerInventory);
        container.func_75142_b();
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendAction(MalisisInventoryContainer.ActionType action, int slotNumber, int code, boolean playerInventory) {
        int windowId = Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75152_c;
        Packet packet = new Packet(action, slotNumber, code, playerInventory, windowId);
        NetworkHandler.network.sendToServer((IMessage)packet);
    }

    public static class Packet
    implements IMessage {
        private MalisisInventoryContainer.ActionType action;
        private int slotNumber;
        private int code;
        private boolean playerInventory;
        private int windowId;

        public Packet() {
        }

        public Packet(MalisisInventoryContainer.ActionType action, int slotNumber, int code, boolean playerInventory, int windowId) {
            this.action = action;
            this.slotNumber = slotNumber;
            this.code = code;
            this.playerInventory = playerInventory;
            this.windowId = windowId;
        }

        public void fromBytes(ByteBuf buf) {
            this.action = MalisisInventoryContainer.ActionType.values()[buf.readByte()];
            this.slotNumber = buf.readInt();
            this.code = buf.readInt();
            this.playerInventory = buf.readBoolean();
            this.windowId = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.action.ordinal());
            buf.writeInt(this.slotNumber);
            buf.writeInt(this.code);
            buf.writeBoolean(this.playerInventory);
            buf.writeInt(this.windowId);
        }
    }
}

