/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import net.malisis.core.renderer.Parameter;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderParameters {
    public Parameter<Boolean> renderAllFaces = new Parameter<Boolean>(false);
    public Parameter<Boolean> useBlockBounds = new Parameter<Boolean>(true);
    public Parameter<double[][]> renderBounds = new Parameter<double[][]>(new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}});
    public Parameter<Boolean> vertexPositionRelativeToRenderBounds = new Parameter<Boolean>(true);
    public Parameter<Boolean> useCustomTexture = new Parameter<Boolean>(false);
    public Parameter<Boolean> applyTexture = new Parameter<Boolean>(true);
    public Parameter<IIcon> icon = new Parameter<Object>(null);
    public Parameter<Boolean> useTexture = new Parameter<Boolean>(true);
    public Parameter<Boolean> interpolateUV = new Parameter<Boolean>(true);
    public Parameter<Boolean> calculateAOColor = new Parameter<Boolean>(true);
    public Parameter<Boolean> calculateBrightness = new Parameter<Boolean>(true);
    public Parameter<Boolean> usePerVertexColor = new Parameter<Boolean>(false);
    public Parameter<Boolean> usePerVertexAlpha = new Parameter<Boolean>(false);
    public Parameter<Boolean> useBlockBrightness = new Parameter<Boolean>(true);
    public Parameter<Boolean> useNormals = new Parameter<Boolean>(false);
    public Parameter<Integer> colorMultiplier = new Parameter<Integer>(0xFFFFFF);
    public Parameter<Float> colorFactor = new Parameter<Float>(Float.valueOf(1.0f));
    public Parameter<Integer> brightness = new Parameter<Integer>(0xF00000);
    public Parameter<Integer> alpha = new Parameter<Integer>(255);
    public Parameter<ForgeDirection> direction = new Parameter<Object>(null);
    public Parameter<ForgeDirection> textureSide = new Parameter<Object>(null);
    public Parameter<int[][][]> aoMatrix = new Parameter<Object>(null);
    public Parameter<Boolean> flipU = new Parameter<Boolean>(false);
    public Parameter<Boolean> flipV = new Parameter<Boolean>(false);

    public RenderParameters() {
    }

    public RenderParameters(RenderParameters params) {
        this.merge(params);
    }

    public void merge(RenderParameters params) {
        if (params == null) {
            return;
        }
        this.renderAllFaces.merge(params.renderAllFaces);
        this.useBlockBounds.merge(params.useBlockBounds);
        this.vertexPositionRelativeToRenderBounds.merge(params.vertexPositionRelativeToRenderBounds);
        this.useCustomTexture.merge(params.useCustomTexture);
        this.applyTexture.merge(params.applyTexture);
        this.icon.merge(params.icon);
        this.useTexture.merge(params.useTexture);
        this.interpolateUV.merge(params.interpolateUV);
        this.calculateAOColor.merge(params.calculateAOColor);
        this.calculateBrightness.merge(params.calculateBrightness);
        this.usePerVertexColor.merge(params.usePerVertexColor);
        this.usePerVertexAlpha.merge(params.usePerVertexAlpha);
        this.useBlockBrightness.merge(params.useBlockBrightness);
        this.useNormals.merge(params.useNormals);
        this.colorMultiplier.merge(params.colorMultiplier);
        this.colorFactor.merge(params.colorFactor);
        this.brightness.merge(params.brightness);
        this.alpha.merge(params.alpha);
        this.direction.merge(params.direction);
        this.textureSide.merge(params.textureSide);
        this.aoMatrix.merge(params.aoMatrix);
        this.flipU.merge(params.flipU);
        this.flipV.merge(params.flipV);
    }

    public static RenderParameters merge(RenderParameters rp1, RenderParameters rp2) {
        RenderParameters rp = new RenderParameters();
        rp.merge(rp1);
        rp.merge(rp2);
        return rp;
    }
}

