/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;

public class Animation {
    private Shape shape;
    private Shape transformedShape;
    private Transformation tranformation;
    private RenderParameters parameters;
    private int delay;
    private boolean started = false;
    private boolean finished = false;
    private boolean renderBefore = false;
    private boolean renderAfter = false;

    public Animation(Shape shape, Transformation transformation, RenderParameters parameters, int delay) {
        this.shape = shape;
        this.tranformation = transformation;
        this.parameters = parameters;
        this.delay = delay;
    }

    public Animation(Shape shape, Transformation transformation) {
        this(shape, transformation, null, 0);
    }

    public void setRender(boolean before, boolean after) {
        this.renderBefore = before;
        this.renderAfter = after;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Shape animate(float elapsedTime) {
        float elapsed = elapsedTime - (float)this.delay;
        this.started = elapsed > (float)this.tranformation.getDelay();
        this.finished = elapsed > (float)this.tranformation.totalDuration() && this.tranformation.getLoops() != -1;
        this.transformedShape = new Shape(this.shape);
        this.tranformation.transform(this.transformedShape, elapsed);
        return this.transformedShape;
    }

    public void render(BaseRenderer renderer) {
        if (!this.started && !this.renderBefore) {
            return;
        }
        if (this.finished && !this.renderAfter) {
            return;
        }
        renderer.drawShape(this.transformedShape, this.parameters);
    }
}

