/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import net.malisis.core.util.Point;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class Vertex {
    public static final int BRIGHTNESS_MAX = 0xF000F0;
    public static final Vertex TopNorthWest = new Vertex(0.0, 1.0, 0.0);
    public static final Vertex TopNorthEast = new Vertex(1.0, 1.0, 0.0);
    public static final Vertex TopSouthWest = new Vertex(0.0, 1.0, 1.0);
    public static final Vertex TopSouthEast = new Vertex(1.0, 1.0, 1.0);
    public static final Vertex BottomNorthWest = new Vertex(0.0, 0.0, 0.0);
    public static final Vertex BottomNorthEast = new Vertex(1.0, 0.0, 0.0);
    public static final Vertex BottomSouthWest = new Vertex(0.0, 0.0, 1.0);
    public static final Vertex BottomSouthEast = new Vertex(1.0, 0.0, 1.0);
    private String baseName;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private int brightness = 0;
    private int color = 0xFFFFFF;
    private int alpha = 255;
    private double u = 0.0;
    private double v = 0.0;

    public Vertex(double x, double y, double z, int rgba, int brightness, double u, double v) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = rgba >>> 8 & 0xFFFFFF;
        this.alpha = rgba & 0xFF;
        this.brightness = brightness;
        this.u = u;
        this.v = v;
        this.baseName();
    }

    public Vertex(double x, double y, double z, int rgba, int brightness) {
        this(x, y, z, rgba, brightness, 0.0, 0.0);
    }

    public Vertex(double x, double y, double z) {
        this(x, y, z, -1, 0xF000F0, 0.0, 0.0);
    }

    public Vertex(Vertex vertex) {
        this(vertex.x, vertex.y, vertex.z, vertex.color << 8 | vertex.alpha, vertex.brightness, vertex.u, vertex.v);
    }

    public Vertex(Vertex vertex, int rgba, int brightness) {
        this(vertex.x, vertex.y, vertex.z, rgba, brightness);
    }

    public Vertex(Vertex vertex, int rgba, int brightness, float u, float v) {
        this(vertex.x, vertex.y, vertex.z, rgba, brightness, u, v);
    }

    public double getX() {
        return this.x;
    }

    public int getIntX() {
        return (int)Math.round(this.x);
    }

    public Vertex setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public int getIntY() {
        return (int)Math.round(this.y);
    }

    public Vertex setY(double y) {
        this.y = y;
        return this;
    }

    public double getZ() {
        return this.z;
    }

    public int getIntZ() {
        return (int)Math.round(this.z);
    }

    public Vertex setZ(double z) {
        this.z = z;
        return this;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void limit(double min, double max) {
        this.x = Vertex.clamp(this.x, min, max);
        this.y = Vertex.clamp(this.y, min, max);
        this.z = Vertex.clamp(this.z, min, max);
    }

    public void interpolateCoord(double[][] bounds) {
        double fx = bounds[1][0] - bounds[0][0];
        double fy = bounds[1][1] - bounds[0][1];
        double fz = bounds[1][2] - bounds[0][2];
        this.x = this.x * fx + bounds[0][0];
        this.y = this.y * fy + bounds[0][1];
        this.z = this.z * fz + bounds[0][2];
    }

    public Vertex add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vertex factorX(float f) {
        this.x *= (double)f;
        return this;
    }

    public Vertex factorY(float f) {
        this.y *= (double)f;
        return this;
    }

    public Vertex factorZ(float f) {
        this.z *= (double)f;
        return this;
    }

    public Vertex factor(float f) {
        this.factorX(f);
        this.factorY(f);
        this.factorZ(f);
        return this;
    }

    public Vertex scale(float f) {
        return this.scale(f, 0.5, 0.5, 0.5);
    }

    public Vertex scale(float f, double centerX, double centerY, double centerZ) {
        this.x = (this.x - centerX) * (double)f + centerX;
        this.y = (this.y - centerY) * (double)f + centerY;
        this.z = (this.z - centerZ) * (double)f + centerZ;
        return this;
    }

    public Vertex rotateAroundX(double angle) {
        return this.rotateAroundX(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundX(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double ty = this.y - centerY;
        double tz = this.z - centerZ;
        this.y = ty * Math.cos(angle) - tz * Math.sin(angle);
        this.z = ty * Math.sin(angle) + tz * Math.cos(angle);
        this.y += centerY;
        this.z += centerZ;
        return this;
    }

    public Vertex rotateAroundY(double angle) {
        return this.rotateAroundY(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundY(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double tx = this.x - centerX;
        double tz = this.z - centerZ;
        this.x = tx * Math.cos(angle) + tz * Math.sin(angle);
        this.z = -tx * Math.sin(angle) + tz * Math.cos(angle);
        this.x += centerX;
        this.z += centerZ;
        return this;
    }

    public Vertex rotateAroundZ(double angle) {
        return this.rotateAroundZ(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundZ(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double tx = this.x - centerX;
        double ty = this.y - centerY;
        this.x = tx * Math.cos(angle) - ty * Math.sin(angle);
        this.y = tx * Math.sin(angle) + ty * Math.cos(angle);
        this.x += centerX;
        this.y += centerY;
        return this;
    }

    public Vertex setColor(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public Vertex setAlpha(int alpha) {
        this.alpha = alpha;
        return this;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Vertex setBrightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setUV(float u, float v) {
        this.u = u;
        this.v = v;
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public void limitU(float min, float max) {
        this.u = Math.max(Math.min(this.u, (double)max), (double)min);
    }

    public void limitV(float min, float max) {
        this.v = Math.max(Math.min(this.v, (double)max), (double)min);
    }

    public boolean isCorner() {
        return !(this.x != 1.0 && this.x != 0.0 || this.y != 1.0 && this.y != 0.0 || this.z != 1.0 && this.z != 0.0);
    }

    public String baseName() {
        if (this.baseName == null) {
            this.baseName = "";
            if (this.isCorner()) {
                this.baseName = (this.y == 1.0 ? "Top" : "Bottom") + (this.z == 1.0 ? "South" : "North") + (this.x == 1.0 ? "East" : "West");
            }
        }
        return this.baseName;
    }

    public String name() {
        return this.baseName() + " [" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public String toString() {
        return this.name() + " 0x" + Integer.toHexString(this.color) + " (a:" + this.alpha + ", b:" + this.brightness + ")";
    }

    public Point toPoint() {
        return new Point(this.x, this.y, this.z);
    }

    public static double clamp(double value) {
        return Vertex.clamp(value, 0.0, 1.0);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void applyMatrix(Matrix4f transformMatrix) {
        Vector4f vec = new Vector4f((float)this.x, (float)this.y, (float)this.z, 1.0f);
        Matrix4f.transform((Matrix4f)transformMatrix, (Vector4f)vec, (Vector4f)vec);
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }
}

