/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model.loader;

import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.model.MalisisModel;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class WavefrontObjectImporter {
    private MalisisModel model;
    public WavefrontObject wfo;

    public WavefrontObjectImporter(WavefrontObject wfo) {
        this.wfo = wfo;
        this.model = new MalisisModel();
    }

    public MalisisModel getModel() {
        return this.model;
    }

    public void load() {
        for (GroupObject go : this.wfo.groupObjects) {
            this.model.addShape(go.name, new Shape(this.getFaces(go)));
        }
    }

    private Face[] getFaces(GroupObject groupObject) {
        Face[] faces = new Face[groupObject.faces.size()];
        int i = 0;
        for (net.minecraftforge.client.model.obj.Face f : groupObject.faces) {
            Face face;
            faces[i] = face = new Face(this.getVertexes(f));
            ++i;
        }
        return faces;
    }

    private Vertex[] getVertexes(net.minecraftforge.client.model.obj.Face f) {
        Vertex[] vertexes = new Vertex[f.vertices.length];
        for (int i = 0; i < f.vertices.length; ++i) {
            net.minecraftforge.client.model.obj.Vertex v = f.vertices[i];
            vertexes[i] = new Vertex(v.x, v.y, v.z);
            if (f.textureCoordinates == null || f.textureCoordinates.length <= 0) continue;
            TextureCoordinate uv = f.textureCoordinates[i];
            vertexes[i].setUV(uv.u, uv.v);
        }
        return vertexes;
    }
}

