/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.util.Point;
import net.malisis.core.util.Vector;

public class Ray {
    public Point origin;
    public Vector direction;

    public Ray(Point p, Vector v) {
        this.origin = p;
        this.direction = v;
    }

    public Ray(Ray r) {
        this.origin = new Point(r.origin);
        this.direction = new Vector(r.direction);
    }

    public Point getPointAt(double t) {
        return new Point(this.origin.x + t * this.direction.x, this.origin.y + t * this.direction.y, this.origin.z + t * this.direction.z);
    }

    public double intersectX(double x) {
        if (this.direction.x == 0.0) {
            return Double.NaN;
        }
        return (x - this.origin.x) / this.direction.x;
    }

    public double intersectY(double y) {
        if (this.direction.y == 0.0) {
            return Double.NaN;
        }
        return (y - this.origin.y) / this.direction.y;
    }

    public double intersectZ(double z) {
        if (this.direction.z == 0.0) {
            return Double.NaN;
        }
        return (z - this.origin.z) / this.direction.z;
    }
}

