/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.malisis.core.MalisisCore;
import net.malisis.doors.entity.VanishingTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3Pool;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;

public class ProxyAccess {
    private static HashMap<IBlockAccess, IBlockAccess> cache = new HashMap();
    private static World tmpCache;
    private static boolean worldInstanciationFailed;

    public static IBlockAccess get(IBlockAccess world) {
        if (world == null) {
            return null;
        }
        Object proxy = cache.get(world);
        if (proxy == null) {
            if (world instanceof World) {
                if (worldInstanciationFailed) {
                    return world;
                }
                try {
                    tmpCache = (World)world;
                    proxy = new ProxyWorld((World)world);
                    tmpCache = null;
                }
                catch (Exception e) {
                    MalisisCore.log.error("[ProxyAccess] Proxy wold instanciation failed : ", (Throwable)e);
                    worldInstanciationFailed = true;
                    return world;
                }
            } else {
                proxy = new ProxyBlockAccess(world);
            }
            cache.put(world, (IBlockAccess)proxy);
        }
        return proxy;
    }

    public static VanishingTileEntity getVanishingTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof VanishingTileEntity) {
            return (VanishingTileEntity)te;
        }
        return null;
    }

    public static Block getBlock(IBlockAccess world, int x, int y, int z) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, x, y, z);
        if (te != null) {
            return te.copiedBlock != null ? te.copiedBlock : Blocks.field_150350_a;
        }
        return world.func_147439_a(x, y, z);
    }

    public static int getMetadata(IBlockAccess world, int x, int y, int z) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, x, y, z);
        if (te != null) {
            return te.copiedMetadata;
        }
        return world.func_72805_g(x, y, z);
    }

    public static TileEntity getTileEntity(IBlockAccess world, int x, int y, int z) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, x, y, z);
        if (te != null) {
            return te.copiedTileEntity;
        }
        return world.func_147438_o(x, y, z);
    }

    static {
        worldInstanciationFailed = false;
    }

    private static class ProxyWorld
    extends World {
        public World original;

        public ProxyWorld(World world) {
            super(world.func_72860_G(), null, new WorldSettings(world.func_72912_H()), world.field_73011_w, (Profiler)null);
            this.original = world;
            this.field_73011_w.field_76579_a = world;
        }

        public Block func_147439_a(int x, int y, int z) {
            return ProxyAccess.getBlock((IBlockAccess)this.original, x, y, z);
        }

        public TileEntity func_147438_o(int x, int y, int z) {
            return ProxyAccess.getTileEntity((IBlockAccess)this.original, x, y, z);
        }

        public int func_72805_g(int x, int y, int z) {
            return ProxyAccess.getMetadata((IBlockAccess)this.original, x, y, z);
        }

        public boolean func_147465_d(int x, int y, int z, Block block, int metadata, int flag) {
            VanishingTileEntity te = ProxyAccess.getVanishingTileEntity((IBlockAccess)this.original, x, y, z);
            if (te != null) {
                te.copiedBlock = block;
                te.copiedMetadata = metadata;
                return true;
            }
            return this.original.func_147465_d(x, y, z, block, metadata, flag);
        }

        public boolean func_72921_c(int x, int y, int z, int metadata, int flag) {
            VanishingTileEntity te = ProxyAccess.getVanishingTileEntity((IBlockAccess)this.original, x, y, z);
            if (te != null && te.copiedBlock != null) {
                te.copiedMetadata = metadata;
                this.func_147459_d(x, y, z, te.copiedBlock);
                return true;
            }
            return this.original.func_72921_c(x, y, z, metadata, flag);
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        public WorldInfo func_72912_H() {
            return tmpCache.func_72912_H();
        }

        public long func_72905_C() {
            return tmpCache.func_72905_C();
        }

        public void func_72966_v() {
        }

        public void calculateInitialWeatherBody() {
        }

        public BiomeGenBase func_72807_a(int par1, int par2) {
            return this.original.func_72807_a(par1, par2);
        }

        public BiomeGenBase getBiomeGenForCoordsBody(int par1, int par2) {
            return this.original.getBiomeGenForCoordsBody(par1, par2);
        }

        public WorldChunkManager func_72959_q() {
            return this.original.func_72959_q();
        }

        public void func_72974_f() {
            this.original.func_72974_f();
        }

        public Block func_147474_b(int p_147474_1_, int p_147474_2_) {
            return this.original.func_147474_b(p_147474_1_, p_147474_2_);
        }

        public boolean func_147437_c(int p_147437_1_, int p_147437_2_, int p_147437_3_) {
            return this.original.func_147437_c(p_147437_1_, p_147437_2_, p_147437_3_);
        }

        public boolean func_72899_e(int par1, int par2, int par3) {
            return this.original.func_72899_e(par1, par2, par3);
        }

        public boolean func_72873_a(int par1, int par2, int par3, int par4) {
            return this.original.func_72873_a(par1, par2, par3, par4);
        }

        public boolean func_72904_c(int par1, int par2, int par3, int par4, int par5, int par6) {
            return this.original.func_72904_c(par1, par2, par3, par4, par5, par6);
        }

        public Chunk func_72938_d(int par1, int par2) {
            return this.original.func_72938_d(par1, par2);
        }

        public Chunk func_72964_e(int par1, int par2) {
            return this.original.func_72964_e(par1, par2);
        }

        public boolean func_147468_f(int p_147468_1_, int p_147468_2_, int p_147468_3_) {
            return this.original.func_147468_f(p_147468_1_, p_147468_2_, p_147468_3_);
        }

        public boolean func_147480_a(int p_147480_1_, int p_147480_2_, int p_147480_3_, boolean p_147480_4_) {
            return this.original.func_147480_a(p_147480_1_, p_147480_2_, p_147480_3_, p_147480_4_);
        }

        public boolean func_147449_b(int p_147449_1_, int p_147449_2_, int p_147449_3_, Block p_147449_4_) {
            return this.original.func_147449_b(p_147449_1_, p_147449_2_, p_147449_3_, p_147449_4_);
        }

        public void func_147471_g(int p_147471_1_, int p_147471_2_, int p_147471_3_) {
            this.original.func_147471_g(p_147471_1_, p_147471_2_, p_147471_3_);
        }

        public void func_147444_c(int p_147444_1_, int p_147444_2_, int p_147444_3_, Block p_147444_4_) {
            this.original.func_147444_c(p_147444_1_, p_147444_2_, p_147444_3_, p_147444_4_);
        }

        public void func_72975_g(int par1, int par2, int par3, int par4) {
            this.original.func_72975_g(par1, par2, par3, par4);
        }

        public void func_147458_c(int p_147458_1_, int p_147458_2_, int p_147458_3_, int p_147458_4_, int p_147458_5_, int p_147458_6_) {
            this.original.func_147458_c(p_147458_1_, p_147458_2_, p_147458_3_, p_147458_4_, p_147458_5_, p_147458_6_);
        }

        public void func_147459_d(int p_147459_1_, int p_147459_2_, int p_147459_3_, Block p_147459_4_) {
            this.original.func_147459_d(p_147459_1_, p_147459_2_, p_147459_3_, p_147459_4_);
        }

        public void func_147441_b(int p_147441_1_, int p_147441_2_, int p_147441_3_, Block p_147441_4_, int p_147441_5_) {
            this.original.func_147441_b(p_147441_1_, p_147441_2_, p_147441_3_, p_147441_4_, p_147441_5_);
        }

        public void func_147460_e(int p_147460_1_, int p_147460_2_, int p_147460_3_, Block p_147460_4_) {
            this.original.func_147460_e(p_147460_1_, p_147460_2_, p_147460_3_, p_147460_4_);
        }

        public boolean func_147477_a(int p_147477_1_, int p_147477_2_, int p_147477_3_, Block p_147477_4_) {
            return this.original.func_147477_a(p_147477_1_, p_147477_2_, p_147477_3_, p_147477_4_);
        }

        public boolean func_72937_j(int par1, int par2, int par3) {
            return this.original.func_72937_j(par1, par2, par3);
        }

        public int func_72883_k(int par1, int par2, int par3) {
            return this.original.func_72883_k(par1, par2, par3);
        }

        public int func_72957_l(int par1, int par2, int par3) {
            return this.original.func_72957_l(par1, par2, par3);
        }

        public int func_72849_a(int par1, int par2, int par3, boolean par4) {
            return this.original.func_72849_a(par1, par2, par3, par4);
        }

        public int func_72976_f(int par1, int par2) {
            return this.original.func_72976_f(par1, par2);
        }

        public int func_82734_g(int par1, int par2) {
            return this.original.func_82734_g(par1, par2);
        }

        public int func_72925_a(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
            return this.original.func_72925_a(par1EnumSkyBlock, par2, par3, par4);
        }

        public int func_72972_b(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
            return this.original.func_72972_b(par1EnumSkyBlock, par2, par3, par4);
        }

        public void func_72915_b(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4, int par5) {
            this.original.func_72915_b(par1EnumSkyBlock, par2, par3, par4, par5);
        }

        public void func_147479_m(int p_147479_1_, int p_147479_2_, int p_147479_3_) {
            this.original.func_147479_m(p_147479_1_, p_147479_2_, p_147479_3_);
        }

        public int func_72802_i(int par1, int par2, int par3, int par4) {
            return this.original.func_72802_i(par1, par2, par3, par4);
        }

        public float func_72801_o(int par1, int par2, int par3) {
            return this.original.func_72801_o(par1, par2, par3);
        }

        public boolean func_72935_r() {
            return this.original.func_72935_r();
        }

        public MovingObjectPosition func_72933_a(Vec3 par1Vec3, Vec3 par2Vec3) {
            return this.original.func_72933_a(par1Vec3, par2Vec3);
        }

        public MovingObjectPosition func_72901_a(Vec3 par1Vec3, Vec3 par2Vec3, boolean par3) {
            return this.original.func_72901_a(par1Vec3, par2Vec3, par3);
        }

        public MovingObjectPosition func_147447_a(Vec3 p_147447_1_, Vec3 p_147447_2_, boolean p_147447_3_, boolean p_147447_4_, boolean p_147447_5_) {
            return this.original.func_147447_a(p_147447_1_, p_147447_2_, p_147447_3_, p_147447_4_, p_147447_5_);
        }

        public void func_72956_a(Entity par1Entity, String par2Str, float par3, float par4) {
            this.original.func_72956_a(par1Entity, par2Str, par3, par4);
        }

        public void func_85173_a(EntityPlayer par1EntityPlayer, String par2Str, float par3, float par4) {
            this.original.func_85173_a(par1EntityPlayer, par2Str, par3, par4);
        }

        public void func_72908_a(double par1, double par3, double par5, String par7Str, float par8, float par9) {
            this.original.func_72908_a(par1, par3, par5, par7Str, par8, par9);
        }

        public void func_72980_b(double par1, double par3, double par5, String par7Str, float par8, float par9, boolean par10) {
            this.original.func_72980_b(par1, par3, par5, par7Str, par8, par9, par10);
        }

        public void func_72934_a(String par1Str, int par2, int par3, int par4) {
            this.original.func_72934_a(par1Str, par2, par3, par4);
        }

        public void func_72869_a(String par1Str, double par2, double par4, double par6, double par8, double par10, double par12) {
            this.original.func_72869_a(par1Str, par2, par4, par6, par8, par10, par12);
        }

        public boolean func_72942_c(Entity par1Entity) {
            return this.original.func_72942_c(par1Entity);
        }

        public boolean func_72838_d(Entity par1Entity) {
            return this.original.func_72838_d(par1Entity);
        }

        public void func_72923_a(Entity par1Entity) {
            this.original.func_72923_a(par1Entity);
        }

        public void func_72847_b(Entity par1Entity) {
            this.original.func_72847_b(par1Entity);
        }

        public void func_72900_e(Entity par1Entity) {
            this.original.func_72900_e(par1Entity);
        }

        public void func_72973_f(Entity par1Entity) {
            this.original.func_72973_f(par1Entity);
        }

        public void func_72954_a(IWorldAccess par1IWorldAccess) {
            this.original.func_72954_a(par1IWorldAccess);
        }

        public List func_72945_a(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB) {
            return this.original.func_72945_a(par1Entity, par2AxisAlignedBB);
        }

        public List func_147461_a(AxisAlignedBB p_147461_1_) {
            return this.original.func_147461_a(p_147461_1_);
        }

        public int func_72967_a(float par1) {
            return this.original.func_72967_a(par1);
        }

        public void func_72848_b(IWorldAccess par1IWorldAccess) {
            this.original.func_72848_b(par1IWorldAccess);
        }

        public float func_72971_b(float par1) {
            return this.original.func_72971_b(par1);
        }

        public Vec3 func_72833_a(Entity par1Entity, float par2) {
            return this.original.func_72833_a(par1Entity, par2);
        }

        public Vec3 getSkyColorBody(Entity par1Entity, float par2) {
            return this.original.getSkyColorBody(par1Entity, par2);
        }

        public float func_72826_c(float par1) {
            return this.original.func_72826_c(par1);
        }

        public int func_72853_d() {
            return this.original.func_72853_d();
        }

        public float func_130001_d() {
            return this.original.func_130001_d();
        }

        public float func_72929_e(float par1) {
            return this.original.func_72929_e(par1);
        }

        public Vec3 func_72824_f(float par1) {
            return this.original.func_72824_f(par1);
        }

        public Vec3 drawCloudsBody(float par1) {
            return this.original.drawCloudsBody(par1);
        }

        public Vec3 func_72948_g(float par1) {
            return this.original.func_72948_g(par1);
        }

        public int func_72874_g(int par1, int par2) {
            return this.original.func_72874_g(par1, par2);
        }

        public int func_72825_h(int par1, int par2) {
            return this.original.func_72825_h(par1, par2);
        }

        public float func_72880_h(float par1) {
            return this.original.func_72880_h(par1);
        }

        public float getStarBrightnessBody(float par1) {
            return this.original.getStarBrightnessBody(par1);
        }

        public void func_147464_a(int p_147464_1_, int p_147464_2_, int p_147464_3_, Block p_147464_4_, int p_147464_5_) {
            this.original.func_147464_a(p_147464_1_, p_147464_2_, p_147464_3_, p_147464_4_, p_147464_5_);
        }

        public void func_147454_a(int p_147454_1_, int p_147454_2_, int p_147454_3_, Block p_147454_4_, int p_147454_5_, int p_147454_6_) {
            this.original.func_147454_a(p_147454_1_, p_147454_2_, p_147454_3_, p_147454_4_, p_147454_5_, p_147454_6_);
        }

        public void func_147446_b(int p_147446_1_, int p_147446_2_, int p_147446_3_, Block p_147446_4_, int p_147446_5_, int p_147446_6_) {
            this.original.func_147446_b(p_147446_1_, p_147446_2_, p_147446_3_, p_147446_4_, p_147446_5_, p_147446_6_);
        }

        public void func_72939_s() {
            this.original.func_72939_s();
        }

        public void func_147448_a(Collection p_147448_1_) {
            this.original.func_147448_a(p_147448_1_);
        }

        public void func_72870_g(Entity par1Entity) {
            this.original.func_72870_g(par1Entity);
        }

        public void func_72866_a(Entity par1Entity, boolean par2) {
            this.original.func_72866_a(par1Entity, par2);
        }

        public boolean func_72855_b(AxisAlignedBB par1AxisAlignedBB) {
            return this.original.func_72855_b(par1AxisAlignedBB);
        }

        public boolean func_72917_a(AxisAlignedBB par1AxisAlignedBB, Entity par2Entity) {
            return this.original.func_72917_a(par1AxisAlignedBB, par2Entity);
        }

        public boolean func_72829_c(AxisAlignedBB par1AxisAlignedBB) {
            return this.original.func_72829_c(par1AxisAlignedBB);
        }

        public boolean func_72953_d(AxisAlignedBB par1AxisAlignedBB) {
            return this.original.func_72953_d(par1AxisAlignedBB);
        }

        public boolean func_147470_e(AxisAlignedBB p_147470_1_) {
            return this.original.func_147470_e(p_147470_1_);
        }

        public boolean func_72918_a(AxisAlignedBB par1AxisAlignedBB, Material par2Material, Entity par3Entity) {
            return this.original.func_72918_a(par1AxisAlignedBB, par2Material, par3Entity);
        }

        public boolean func_72875_a(AxisAlignedBB par1AxisAlignedBB, Material par2Material) {
            return this.original.func_72875_a(par1AxisAlignedBB, par2Material);
        }

        public boolean func_72830_b(AxisAlignedBB par1AxisAlignedBB, Material par2Material) {
            return this.original.func_72830_b(par1AxisAlignedBB, par2Material);
        }

        public Explosion func_72876_a(Entity par1Entity, double par2, double par4, double par6, float par8, boolean par9) {
            return this.original.func_72876_a(par1Entity, par2, par4, par6, par8, par9);
        }

        public Explosion func_72885_a(Entity par1Entity, double par2, double par4, double par6, float par8, boolean par9, boolean par10) {
            return this.original.func_72885_a(par1Entity, par2, par4, par6, par8, par9, par10);
        }

        public float func_72842_a(Vec3 par1Vec3, AxisAlignedBB par2AxisAlignedBB) {
            return this.original.func_72842_a(par1Vec3, par2AxisAlignedBB);
        }

        public boolean func_72886_a(EntityPlayer par1EntityPlayer, int par2, int par3, int par4, int par5) {
            return this.original.func_72886_a(par1EntityPlayer, par2, par3, par4, par5);
        }

        public String func_72981_t() {
            return this.original.func_72981_t();
        }

        public String func_72827_u() {
            return this.original.func_72827_u();
        }

        public void func_147455_a(int p_147455_1_, int p_147455_2_, int p_147455_3_, TileEntity p_147455_4_) {
            this.original.func_147455_a(p_147455_1_, p_147455_2_, p_147455_3_, p_147455_4_);
        }

        public void func_147475_p(int p_147475_1_, int p_147475_2_, int p_147475_3_) {
            this.original.func_147475_p(p_147475_1_, p_147475_2_, p_147475_3_);
        }

        public void func_147457_a(TileEntity p_147457_1_) {
            this.original.func_147457_a(p_147457_1_);
        }

        public boolean func_147469_q(int p_147469_1_, int p_147469_2_, int p_147469_3_) {
            return this.original.func_147469_q(p_147469_1_, p_147469_2_, p_147469_3_);
        }

        public boolean func_147445_c(int p_147445_1_, int p_147445_2_, int p_147445_3_, boolean p_147445_4_) {
            return this.original.func_147445_c(p_147445_1_, p_147445_2_, p_147445_3_, p_147445_4_);
        }

        public void func_72891_a(boolean par1, boolean par2) {
            this.original.func_72891_a(par1, par2);
        }

        public void func_72835_b() {
            this.original.func_72835_b();
        }

        public void updateWeatherBody() {
            this.original.updateWeatherBody();
        }

        public boolean func_72884_u(int par1, int par2, int par3) {
            return this.original.func_72884_u(par1, par2, par3);
        }

        public boolean func_72850_v(int par1, int par2, int par3) {
            return this.original.func_72850_v(par1, par2, par3);
        }

        public boolean func_72834_c(int par1, int par2, int par3, boolean par4) {
            return this.original.func_72834_c(par1, par2, par3, par4);
        }

        public boolean canBlockFreezeBody(int par1, int par2, int par3, boolean par4) {
            return this.original.canBlockFreezeBody(par1, par2, par3, par4);
        }

        public boolean func_147478_e(int p_147478_1_, int p_147478_2_, int p_147478_3_, boolean p_147478_4_) {
            return this.original.func_147478_e(p_147478_1_, p_147478_2_, p_147478_3_, p_147478_4_);
        }

        public boolean canSnowAtBody(int p_147478_1_, int p_147478_2_, int p_147478_3_, boolean p_147478_4_) {
            return this.original.canSnowAtBody(p_147478_1_, p_147478_2_, p_147478_3_, p_147478_4_);
        }

        public boolean func_147451_t(int p_147451_1_, int p_147451_2_, int p_147451_3_) {
            return this.original.func_147451_t(p_147451_1_, p_147451_2_, p_147451_3_);
        }

        public boolean func_147463_c(EnumSkyBlock p_147463_1_, int p_147463_2_, int p_147463_3_, int p_147463_4_) {
            return this.original.func_147463_c(p_147463_1_, p_147463_2_, p_147463_3_, p_147463_4_);
        }

        public boolean func_72955_a(boolean par1) {
            return this.original.func_72955_a(par1);
        }

        public List func_72920_a(Chunk par1Chunk, boolean par2) {
            return this.original.func_72920_a(par1Chunk, par2);
        }

        public List func_72839_b(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB) {
            return this.original.func_72839_b(par1Entity, par2AxisAlignedBB);
        }

        public List func_94576_a(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB, IEntitySelector par3IEntitySelector) {
            return this.original.func_94576_a(par1Entity, par2AxisAlignedBB, par3IEntitySelector);
        }

        public List func_72872_a(Class par1Class, AxisAlignedBB par2AxisAlignedBB) {
            return this.original.func_72872_a(par1Class, par2AxisAlignedBB);
        }

        public List func_82733_a(Class par1Class, AxisAlignedBB par2AxisAlignedBB, IEntitySelector par3IEntitySelector) {
            return this.original.func_82733_a(par1Class, par2AxisAlignedBB, par3IEntitySelector);
        }

        public Entity func_72857_a(Class par1Class, AxisAlignedBB par2AxisAlignedBB, Entity par3Entity) {
            return this.original.func_72857_a(par1Class, par2AxisAlignedBB, par3Entity);
        }

        public Entity func_73045_a(int arg0) {
            return this.original.func_73045_a(arg0);
        }

        public List func_72910_y() {
            return this.original.func_72910_y();
        }

        public void func_147476_b(int p_147476_1_, int p_147476_2_, int p_147476_3_, TileEntity p_147476_4_) {
            this.original.func_147476_b(p_147476_1_, p_147476_2_, p_147476_3_, p_147476_4_);
        }

        public int func_72907_a(Class par1Class) {
            return this.original.func_72907_a(par1Class);
        }

        public void func_72868_a(List par1List) {
            this.original.func_72868_a(par1List);
        }

        public void func_72828_b(List par1List) {
            this.original.func_72828_b(par1List);
        }

        public boolean func_147472_a(Block p_147472_1_, int p_147472_2_, int p_147472_3_, int p_147472_4_, boolean p_147472_5_, int p_147472_6_, Entity p_147472_7_, ItemStack p_147472_8_) {
            return this.original.func_147472_a(p_147472_1_, p_147472_2_, p_147472_3_, p_147472_4_, p_147472_5_, p_147472_6_, p_147472_7_, p_147472_8_);
        }

        public PathEntity func_72865_a(Entity par1Entity, Entity par2Entity, float par3, boolean par4, boolean par5, boolean par6, boolean par7) {
            return this.original.func_72865_a(par1Entity, par2Entity, par3, par4, par5, par6, par7);
        }

        public PathEntity func_72844_a(Entity par1Entity, int par2, int par3, int par4, float par5, boolean par6, boolean par7, boolean par8, boolean par9) {
            return this.original.func_72844_a(par1Entity, par2, par3, par4, par5, par6, par7, par8, par9);
        }

        public int func_72879_k(int par1, int par2, int par3, int par4) {
            return this.original.func_72879_k(par1, par2, par3, par4);
        }

        public int func_94577_B(int par1, int par2, int par3) {
            return this.original.func_94577_B(par1, par2, par3);
        }

        public boolean func_94574_k(int par1, int par2, int par3, int par4) {
            return this.original.func_94574_k(par1, par2, par3, par4);
        }

        public int func_72878_l(int par1, int par2, int par3, int par4) {
            return this.original.func_72878_l(par1, par2, par3, par4);
        }

        public boolean func_72864_z(int par1, int par2, int par3) {
            return this.original.func_72864_z(par1, par2, par3);
        }

        public int func_94572_D(int par1, int par2, int par3) {
            return this.original.func_94572_D(par1, par2, par3);
        }

        public EntityPlayer func_72890_a(Entity par1Entity, double par2) {
            return this.original.func_72890_a(par1Entity, par2);
        }

        public EntityPlayer func_72977_a(double par1, double par3, double par5, double par7) {
            return this.original.func_72977_a(par1, par3, par5, par7);
        }

        public EntityPlayer func_72856_b(Entity par1Entity, double par2) {
            return this.original.func_72856_b(par1Entity, par2);
        }

        public EntityPlayer func_72846_b(double par1, double par3, double par5, double par7) {
            return this.original.func_72846_b(par1, par3, par5, par7);
        }

        public EntityPlayer func_72924_a(String par1Str) {
            return this.original.func_72924_a(par1Str);
        }

        public void func_72882_A() {
            this.original.func_72882_A();
        }

        public void func_72906_B() throws MinecraftException {
            this.original.func_72906_B();
        }

        public void func_82738_a(long par1) {
            this.original.func_82738_a(par1);
        }

        public long func_82737_E() {
            return this.original.func_82737_E();
        }

        public long func_72820_D() {
            return this.original.func_72820_D();
        }

        public void func_72877_b(long par1) {
            this.original.func_72877_b(par1);
        }

        public ChunkCoordinates func_72861_E() {
            return this.original.func_72861_E();
        }

        public void func_72950_A(int par1, int par2, int par3) {
            this.original.func_72950_A(par1, par2, par3);
        }

        public void func_72897_h(Entity par1Entity) {
            this.original.func_72897_h(par1Entity);
        }

        public boolean func_72962_a(EntityPlayer par1EntityPlayer, int par2, int par3, int par4) {
            return this.original.func_72962_a(par1EntityPlayer, par2, par3, par4);
        }

        public boolean canMineBlockBody(EntityPlayer par1EntityPlayer, int par2, int par3, int par4) {
            return this.original.canMineBlockBody(par1EntityPlayer, par2, par3, par4);
        }

        public void func_72960_a(Entity par1Entity, byte par2) {
            this.original.func_72960_a(par1Entity, par2);
        }

        public IChunkProvider func_72863_F() {
            return this.original.func_72863_F();
        }

        public void func_147452_c(int p_147452_1_, int p_147452_2_, int p_147452_3_, Block p_147452_4_, int p_147452_5_, int p_147452_6_) {
            this.original.func_147452_c(p_147452_1_, p_147452_2_, p_147452_3_, p_147452_4_, p_147452_5_, p_147452_6_);
        }

        public ISaveHandler func_72860_G() {
            return this.original.func_72860_G();
        }

        public GameRules func_82736_K() {
            return this.original.func_82736_K();
        }

        public void func_72854_c() {
            this.original.func_72854_c();
        }

        public float func_72819_i(float par1) {
            return this.original.func_72819_i(par1);
        }

        public void func_147442_i(float p_147442_1_) {
            this.original.func_147442_i(p_147442_1_);
        }

        public float func_72867_j(float par1) {
            return this.original.func_72867_j(par1);
        }

        public void func_72894_k(float par1) {
            this.original.func_72894_k(par1);
        }

        public boolean func_72911_I() {
            return this.original.func_72911_I();
        }

        public boolean func_72896_J() {
            return this.original.func_72896_J();
        }

        public boolean func_72951_B(int par1, int par2, int par3) {
            return this.original.func_72951_B(par1, par2, par3);
        }

        public boolean func_72958_C(int par1, int par2, int par3) {
            return this.original.func_72958_C(par1, par2, par3);
        }

        public void func_72823_a(String par1Str, WorldSavedData par2WorldSavedData) {
            this.original.func_72823_a(par1Str, par2WorldSavedData);
        }

        public WorldSavedData func_72943_a(Class par1Class, String par2Str) {
            return this.original.func_72943_a(par1Class, par2Str);
        }

        public int func_72841_b(String par1Str) {
            return this.original.func_72841_b(par1Str);
        }

        public void func_82739_e(int par1, int par2, int par3, int par4, int par5) {
            this.original.func_82739_e(par1, par2, par3, par4, par5);
        }

        public void func_72926_e(int par1, int par2, int par3, int par4, int par5) {
            this.original.func_72926_e(par1, par2, par3, par4, par5);
        }

        public void func_72889_a(EntityPlayer par1EntityPlayer, int par2, int par3, int par4, int par5, int par6) {
            this.original.func_72889_a(par1EntityPlayer, par2, par3, par4, par5, par6);
        }

        public int func_72800_K() {
            return this.original.func_72800_K();
        }

        public int func_72940_L() {
            return this.original.func_72940_L();
        }

        public Random func_72843_D(int par1, int par2, int par3) {
            return this.original.func_72843_D(par1, par2, par3);
        }

        public ChunkPosition func_147440_b(String p_147440_1_, int p_147440_2_, int p_147440_3_, int p_147440_4_) {
            return this.original.func_147440_b(p_147440_1_, p_147440_2_, p_147440_3_, p_147440_4_);
        }

        public boolean func_72806_N() {
            return this.original.func_72806_N();
        }

        public double func_72919_O() {
            return this.original.func_72919_O();
        }

        public CrashReportCategory func_72914_a(CrashReport par1CrashReport) {
            return this.original.func_72914_a(par1CrashReport);
        }

        public void func_147443_d(int p_147443_1_, int p_147443_2_, int p_147443_3_, int p_147443_4_, int p_147443_5_) {
            this.original.func_147443_d(p_147443_1_, p_147443_2_, p_147443_3_, p_147443_4_, p_147443_5_);
        }

        public Vec3Pool func_82732_R() {
            return this.original.func_82732_R();
        }

        public Calendar func_83015_S() {
            return this.original.func_83015_S();
        }

        public void func_92088_a(double par1, double par3, double par5, double par7, double par9, double par11, NBTTagCompound par13NBTTagCompound) {
            this.original.func_92088_a(par1, par3, par5, par7, par9, par11, par13NBTTagCompound);
        }

        public Scoreboard func_96441_U() {
            return this.original.func_96441_U();
        }

        public void func_147453_f(int p_147453_1_, int p_147453_2_, int p_147453_3_, Block p_147453_4_) {
            this.original.func_147453_f(p_147453_1_, p_147453_2_, p_147453_3_, p_147453_4_);
        }

        public float func_147462_b(double p_147462_1_, double p_147462_3_, double p_147462_5_) {
            return this.original.func_147462_b(p_147462_1_, p_147462_3_, p_147462_5_);
        }

        public float func_147473_B(int p_147473_1_, int p_147473_2_, int p_147473_3_) {
            return this.original.func_147473_B(p_147473_1_, p_147473_2_, p_147473_3_);
        }

        public void func_147450_X() {
            this.original.func_147450_X();
        }

        public void addTileEntity(TileEntity entity) {
            this.original.addTileEntity(entity);
        }

        public boolean isSideSolid(int x, int y, int z, ForgeDirection side) {
            return this.original.isSideSolid(x, y, z, side);
        }

        public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
            return this.original.isSideSolid(x, y, z, side, _default);
        }

        public ImmutableSetMultimap<ChunkCoordIntPair, ForgeChunkManager.Ticket> getPersistentChunks() {
            return this.original.getPersistentChunks();
        }

        public int getBlockLightOpacity(int x, int y, int z) {
            return this.original.getBlockLightOpacity(x, y, z);
        }

        public int countEntities(EnumCreatureType type, boolean forSpawnCount) {
            return this.original.countEntities(type, forSpawnCount);
        }
    }

    private static class ProxyBlockAccess
    implements IBlockAccess {
        public IBlockAccess original;

        public ProxyBlockAccess(IBlockAccess world) {
            this.original = world;
        }

        public Block func_147439_a(int x, int y, int z) {
            return ProxyAccess.getBlock(this.original, x, y, z);
        }

        public TileEntity func_147438_o(int x, int y, int z) {
            return ProxyAccess.getTileEntity(this.original, x, y, z);
        }

        public int func_72805_g(int x, int y, int z) {
            return ProxyAccess.getMetadata(this.original, x, y, z);
        }

        public int func_72802_i(int arg0, int arg1, int arg2, int arg3) {
            return this.original.func_72802_i(arg0, arg1, arg2, arg3);
        }

        public boolean func_147437_c(int arg0, int arg1, int arg2) {
            return this.original.func_147437_c(arg0, arg1, arg2);
        }

        public BiomeGenBase func_72807_a(int arg0, int arg1) {
            return this.original.func_72807_a(arg0, arg1);
        }

        public int func_72800_K() {
            return this.original.func_72800_K();
        }

        public boolean func_72806_N() {
            return this.original.func_72806_N();
        }

        public Vec3Pool func_82732_R() {
            return this.original.func_82732_R();
        }

        public int func_72879_k(int arg0, int arg1, int arg2, int arg3) {
            return this.original.func_72879_k(arg0, arg1, arg2, arg3);
        }

        public boolean isSideSolid(int arg0, int arg1, int arg2, ForgeDirection arg3, boolean arg4) {
            return this.original.isSideSolid(arg0, arg1, arg2, arg3, arg4);
        }
    }

    private static interface IProxyAccess {
        public Block getBlock(int var1, int var2, int var3);

        public TileEntity getTileEntity(int var1, int var2, int var3);

        public int getBlockMetadata(int var1, int var2, int var3);

        public boolean setBlockMetadataWithNotify(int var1, int var2, int var3, int var4, int var5);

        public boolean setBlock(int var1, int var2, int var3, Block var4, int var5, int var6);

        public WorldInfo getWorldInfo();

        public WorldInfo getSeed();

        public void calculateInitialSkylight();

        public void calculateInitialWeatherBody();
    }
}

