/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors;

import cpw.mods.fml.common.registry.GameRegistry;
import net.malisis.core.MalisisCore;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.block.BlockMixer;
import net.malisis.doors.block.DoorFactory;
import net.malisis.doors.block.FenceGate;
import net.malisis.doors.block.GarageDoor;
import net.malisis.doors.block.MixedBlock;
import net.malisis.doors.block.PlayerSensor;
import net.malisis.doors.block.TrapDoor;
import net.malisis.doors.block.VanishingBlock;
import net.malisis.doors.block.VanishingDiamondBlock;
import net.malisis.doors.door.CustomDoor;
import net.malisis.doors.door.CustomDoorItem;
import net.malisis.doors.door.Door;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.descriptor.FactoryDoor;
import net.malisis.doors.door.descriptor.GlassDoor;
import net.malisis.doors.door.descriptor.JailDoor;
import net.malisis.doors.door.descriptor.LaboratoryDoor;
import net.malisis.doors.door.descriptor.VanillaDoor;
import net.malisis.doors.door.tileentity.CustomDoorTileEntity;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.door.tileentity.FenceGateTileEntity;
import net.malisis.doors.door.tileentity.TrapDoorTileEntity;
import net.malisis.doors.entity.BlockMixerTileEntity;
import net.malisis.doors.entity.DoorFactoryTileEntity;
import net.malisis.doors.entity.GarageDoorTileEntity;
import net.malisis.doors.entity.MixedBlockTileEntity;
import net.malisis.doors.entity.VanishingDiamondTileEntity;
import net.malisis.doors.entity.VanishingTileEntity;
import net.malisis.doors.item.MixedBlockBlockItem;
import net.malisis.doors.item.VanishingBlockItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Registers {
    public static void init() {
        if (((Boolean)MalisisDoorsSettings.modifyVanillaDoors.get()).booleanValue()) {
            Registers.registerVanillaDoors();
        }
        Registers.registerDoors();
        Registers.registerPlayerSensor();
        if (((Boolean)MalisisDoorsSettings.enableVanishingBlocks.get()).booleanValue()) {
            Registers.registerVanishingBlock();
        }
        if (((Boolean)MalisisDoorsSettings.enableMixedBlocks.get()).booleanValue()) {
            Registers.registerMixedBlock();
        }
        Registers.registerGarageDoor();
        Registers.registerDoorFactory();
        Registers.registerCustomDoor();
        GameRegistry.registerTileEntity(DoorTileEntity.class, (String)"doorTileEntity");
    }

    private static void registerVanillaDoors() {
        VanillaDoor woodDoor = new VanillaDoor(Material.field_151575_d);
        woodDoor.set((Block)new Door(woodDoor), Items.field_151135_aq);
        MalisisCore.replaceVanillaBlock((int)64, (String)"wooden_door", (String)"field_150466_ao", (Block)woodDoor.getBlock(), (Block)Blocks.field_150466_ao);
        MalisisDoors.Blocks.doubleDoorWood = woodDoor.getBlock();
        VanillaDoor ironDoor = new VanillaDoor(Material.field_151573_f);
        ironDoor.set((Block)new Door(ironDoor), Items.field_151139_aw);
        MalisisCore.replaceVanillaBlock((int)71, (String)"iron_door", (String)"field_150454_av", (Block)ironDoor.getBlock(), (Block)Blocks.field_150454_av);
        MalisisDoors.Blocks.doubleDoorIron = ironDoor.getBlock();
        MalisisDoors.Blocks.fenceGate = new FenceGate();
        MalisisDoors.Blocks.trapDoor = new TrapDoor();
        MalisisCore.replaceVanillaBlock((int)107, (String)"fence_gate", (String)"field_150396_be", (Block)MalisisDoors.Blocks.fenceGate, (Block)Blocks.field_150396_be);
        MalisisCore.replaceVanillaBlock((int)96, (String)"trapdoor", (String)"field_150415_aT", (Block)MalisisDoors.Blocks.trapDoor, (Block)Blocks.field_150415_aT);
        GameRegistry.registerTileEntity(FenceGateTileEntity.class, (String)"fenceGateTileEntity");
        GameRegistry.registerTileEntity(TrapDoorTileEntity.class, (String)"trapDoorTileEntity");
    }

    private static void registerDoors() {
        DoorDescriptor desc = new GlassDoor(Material.field_151575_d).register();
        MalisisDoors.Blocks.woodSlidingDoor = desc.getBlock();
        MalisisDoors.Items.woodSlidingDoorItem = desc.getItem();
        desc = new GlassDoor(Material.field_151573_f).register();
        MalisisDoors.Blocks.ironSlidingDoor = desc.getBlock();
        MalisisDoors.Items.ironSlidingDoorItem = desc.getItem();
        desc = new JailDoor().register();
        MalisisDoors.Blocks.jailDoor = desc.getBlock();
        MalisisDoors.Items.jailDoorItem = desc.getItem();
        desc = new LaboratoryDoor().register();
        MalisisDoors.Blocks.laboratoryDoor = desc.getBlock();
        MalisisDoors.Items.laboratoryDoorItem = desc.getItem();
        desc = new FactoryDoor().register();
        MalisisDoors.Blocks.factoryDoor = desc.getBlock();
        MalisisDoors.Items.facortyDoorItem = desc.getItem();
    }

    private static void registerPlayerSensor() {
        MalisisDoors.Blocks.playerSensor = new PlayerSensor();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.playerSensor, (String)MalisisDoors.Blocks.playerSensor.func_149739_a().substring(5));
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.playerSensor), (Object[])new Object[]{"ABA", "CCC", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Items.field_151137_ax, Character.valueOf('C'), Blocks.field_150359_w});
    }

    private static void registerVanishingBlock() {
        MalisisDoors.Blocks.vanishingBlock = new VanishingBlock();
        MalisisDoors.Blocks.vanishingDiamondBlock = new VanishingDiamondBlock();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.vanishingBlock, VanishingBlockItem.class, (String)MalisisDoors.Blocks.vanishingBlock.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.vanishingDiamondBlock, (String)MalisisDoors.Blocks.vanishingDiamondBlock.func_149739_a().substring(5));
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.vanishingBlock, 4, 0), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151055_y, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.vanishingBlock, 4, 1), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.vanishingBlock, 4, 2), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151043_k, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.vanishingDiamondBlock, 4, 3), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151045_i, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.registerTileEntity(VanishingTileEntity.class, (String)"vanishingTileEntity");
        GameRegistry.registerTileEntity(VanishingDiamondTileEntity.class, (String)"vanishingDiamondTileEntity");
    }

    private static void registerMixedBlock() {
        MalisisDoors.Blocks.blockMixer = new BlockMixer();
        MalisisDoors.Blocks.mixedBlock = new MixedBlock();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.blockMixer, (String)MalisisDoors.Blocks.blockMixer.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.mixedBlock, MixedBlockBlockItem.class, (String)MalisisDoors.Blocks.mixedBlock.func_149739_a().substring(5));
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.blockMixer), (Object[])new Object[]{"AAA", "B B", "AAA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150331_J});
        GameRegistry.registerTileEntity(BlockMixerTileEntity.class, (String)"blockMixerTileEntity");
        GameRegistry.registerTileEntity(MixedBlockTileEntity.class, (String)"mixedBlockTileEntity");
    }

    private static void registerGarageDoor() {
        MalisisDoors.Blocks.garageDoor = new GarageDoor();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.garageDoor, (String)MalisisDoors.Blocks.garageDoor.func_149739_a().substring(5));
        GameRegistry.registerTileEntity(GarageDoorTileEntity.class, (String)"garageDoorTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.garageDoor), (Object[])new Object[]{"ABA", "AAA", Character.valueOf('A'), Blocks.field_150344_f, Character.valueOf('B'), Blocks.field_150359_w});
    }

    private static void registerDoorFactory() {
        MalisisDoors.Blocks.doorFactory = new DoorFactory();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.doorFactory, (String)MalisisDoors.Blocks.doorFactory.func_149739_a().substring(5));
        GameRegistry.registerTileEntity(DoorFactoryTileEntity.class, (String)"doorFactoryTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Blocks.doorFactory), (Object[])new Object[]{"ABA", "C C", "ADA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Items.field_151139_aw, Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('D'), Blocks.field_150331_J});
    }

    private static void registerCustomDoor() {
        MalisisDoors.Blocks.customDoor = new CustomDoor();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.customDoor, (String)MalisisDoors.Blocks.customDoor.func_149739_a().substring(5));
        MalisisDoors.Items.customDoorItem = new CustomDoorItem();
        GameRegistry.registerItem((Item)MalisisDoors.Items.customDoorItem, (String)MalisisDoors.Items.customDoorItem.func_77658_a());
        GameRegistry.registerTileEntity(CustomDoorTileEntity.class, (String)"customDoorTileEntity");
    }
}

