/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.malisis.core.renderer.MalisisIcon;
import net.malisis.core.renderer.TextureIcon;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Door
extends BlockDoor
implements ITileEntityProvider {
    public static final int DIR_WEST = 0;
    public static final int DIR_NORTH = 1;
    public static final int DIR_EAST = 2;
    public static final int DIR_SOUTH = 3;
    public static final float DOOR_WIDTH = 0.1875f;
    public static final int FLAG_OPENED = 4;
    public static final int FLAG_TOPBLOCK = 8;
    public static final int FLAG_REVERSED = 16;
    protected MalisisIcon iconTop;
    protected MalisisIcon iconBottom;
    protected MalisisIcon iconSide;
    protected String soundPath;
    private DoorDescriptor descriptor;

    public Door(DoorDescriptor desc) {
        super(desc.getMaterial());
        this.descriptor = desc;
        this.func_149711_c(desc.getHardness());
        this.func_149672_a(desc.getSoundType());
        this.func_149663_c(desc.getName());
        this.func_149658_d(desc.getTextureName());
    }

    public Door() {
        super(Material.field_151575_d);
    }

    public DoorDescriptor getDescriptor() {
        return this.descriptor;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String textureName = this.func_149641_N();
        this.iconTop = new TextureIcon((TextureAtlasSprite)register.func_94245_a(textureName + "_upper"));
        this.iconBottom = new TextureIcon((TextureAtlasSprite)register.func_94245_a(textureName + "_lower"));
        if (textureName.equals("door_wood") || textureName.equals("door_iron")) {
            textureName = "malisisdoors:" + textureName;
        }
        this.iconSide = new TextureIcon((TextureAtlasSprite)register.func_94245_a(textureName + "_side"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        boolean topBlock = (metadata & 8) != 0;
        boolean reversed = (metadata & 0x10) != 0;
        MalisisIcon icon = this.iconBottom;
        switch (side) {
            case 0: 
            case 1: {
                icon = this.iconSide.clone();
                icon.clip(0, 0, 3, 16);
                icon.setRotation(1);
                return icon;
            }
            case 4: {
                icon = this.iconSide.clone();
                icon.clip(topBlock ? 3 : 9, 0, 3, 16);
                return icon;
            }
            case 5: {
                icon = this.iconSide.clone();
                icon.clip(topBlock ? 6 : 12, 0, 3, 16);
                return icon;
            }
            case 2: {
                icon = topBlock ? this.iconTop : this.iconBottom;
                icon.flip(reversed, false);
                return icon;
            }
            case 3: {
                icon = topBlock ? this.iconTop : this.iconBottom;
                icon.flip(!reversed, false);
                return icon;
            }
        }
        return icon;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer p, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return true;
        }
        if (te.getDescriptor().requireRedstone()) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public void func_150014_a(World world, int x, int y, int z, boolean opening) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        if (te.getDescriptor().requireRedstone()) {
            return;
        }
        if (opening && te.isOpened()) {
            return;
        }
        te.openOrCloseDoor();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        if ((metadata & 8) == 0) {
            boolean flag = false;
            ItemStack itemStack = this.getDoorItemStack((IBlockAccess)world, x, y, z);
            if (world.func_147439_a(x, y + 1, z) != this) {
                world.func_147468_f(x, y, z);
                flag = true;
            }
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
                world.func_147468_f(x, y, z);
                flag = true;
                if (world.func_147439_a(x, y + 1, z) == this) {
                    world.func_147468_f(x, y + 1, z);
                }
            }
            if (flag) {
                if (!world.field_72995_K && itemStack != null) {
                    this.func_149642_a(world, x, y, z, itemStack);
                }
            } else {
                DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
                if (te == null) {
                    return;
                }
                boolean powered = te.isPowered();
                if ((powered || block.func_149744_f()) && block != this) {
                    te.setPowered(powered);
                }
            }
        } else {
            if (world.func_147439_a(x, y - 1, z) != this) {
                world.func_147468_f(x, y, z);
            }
            if (block != this) {
                this.func_149695_a(world, x, y - 1, z, block);
            }
        }
    }

    protected ItemStack getDoorItemStack(IBlockAccess world, int x, int y, int z) {
        return new ItemStack(this.descriptor.getItem(), 1);
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return this.descriptor.getItem();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return this.descriptor.getItem();
    }

    protected AxisAlignedBB setBlockBounds(AxisAlignedBB aabb) {
        if (aabb == null) {
            aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        this.func_149676_a((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
        return aabb;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor(world, x, y, z);
        if (te == null || te.isMoving() || te.getMovement() == null) {
            return;
        }
        this.setBlockBounds(te.getMovement().getBoundingBox(te, te.isTopBlock(x, y, z), false));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null || te.isMoving() || te.getMovement() == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        AxisAlignedBB aabb = te.getMovement().getBoundingBox(te, te.isTopBlock(x, y, z), true);
        if (aabb == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return aabb.func_72317_d((double)x, (double)y, (double)z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null || te.isMoving() || te.getMovement() == null) {
            return null;
        }
        AxisAlignedBB aabb = te.getMovement().getBoundingBox(te, te.isTopBlock(x, y, z), false);
        if (aabb == null) {
            return null;
        }
        return this.setBlockBounds(aabb.func_72317_d((double)x, (double)y, (double)z));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if ((metadata & 8) != 0) {
            return null;
        }
        DoorTileEntity te = new DoorTileEntity();
        te.setDescriptor(this.descriptor);
        return te;
    }

    public int func_149645_b() {
        return -1;
    }

    public static DoorTileEntity getDoor(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = Door.getFullMetadata(world, x, y, z);
        if (block instanceof Door) {
            y -= (metadata & 8) != 0 ? 1 : 0;
        }
        return (DoorTileEntity)TileEntityUtils.getTileEntity(DoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z);
    }

    public static int getFullMetadata(IBlockAccess world, int x, int y, int z) {
        int topMetadata;
        int bottomMetadata;
        boolean blockTop;
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (!(block instanceof BlockDoor)) {
            return metadata;
        }
        boolean bl = blockTop = (metadata & 8) != 0;
        if (blockTop) {
            bottomMetadata = world.func_72805_g(x, y - 1, z);
            topMetadata = metadata;
        } else {
            bottomMetadata = metadata;
            topMetadata = world.func_72805_g(x, y + 1, z);
        }
        boolean flag1 = (topMetadata & 1) != 0;
        return bottomMetadata & 7 | (blockTop ? 8 : 0) | (flag1 ? 16 : 0);
    }
}

