/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class RotatingSplitMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, boolean selBox) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (!opened) {
            if (dir == 1) {
                Z = 0.1875f;
            } else if (dir == 0) {
                X = 0.1875f;
            } else if (dir == 2) {
                x = 0.8125f;
            } else if (dir == 3) {
                z = 0.8125f;
            }
        } else if (topBlock) {
            y = 0.8125f;
        } else {
            float f = Y = selBox ? 0.1875f : 0.0f;
        }
        if (selBox && !opened) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Transformation getTopTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, true);
    }

    @Override
    public Transformation getBottomTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, false);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float angle = 90.0f;
        float hingeY = -0.40625f;
        float hingeZ = -0.40625f;
        if (topBlock) {
            angle = -angle;
            hingeY = -hingeY;
        }
        Rotation rot = new Rotation(angle).aroundAxis(1.0f, 0.0f, 0.0f).offset(0.0f, hingeY, hingeZ);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            rot.reversed(true);
        }
        return rot.forTicks(tileEntity.getDescriptor().getOpeningTime());
    }
}

