/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class SlidingDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, boolean selBox) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        boolean reversed = tileEntity.isReversed();
        float left = -0.8125f;
        float right = 0.8125f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1) {
            Z = 0.1875f;
            if (opened) {
                x += reversed ? left : right;
                X += reversed ? left : right;
            }
        }
        if (dir == 3) {
            z = 0.8125f;
            if (opened) {
                x += reversed ? right : left;
                X += reversed ? right : left;
            }
        }
        if (dir == 0) {
            X = 0.1875f;
            if (opened) {
                z += reversed ? right : left;
                Z += reversed ? right : left;
            }
        }
        if (dir == 2) {
            x = 0.8125f;
            if (opened) {
                z += reversed ? left : right;
                Z += reversed ? left : right;
            }
        }
        if (selBox) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Transformation getTopTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity);
    }

    @Override
    public Transformation getBottomTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity) {
        float fromX = 0.0f;
        float toX = 0.8125f;
        if (tileEntity.isReversed()) {
            fromX = 0.0f;
            toX = -0.8125f;
        }
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            float tmp = fromX;
            fromX = toX;
            toX = tmp;
        }
        return new Translation(fromX, 0.0f, 0.0f, toX, 0.0f, 0.0f).forTicks(tileEntity.getDescriptor().getOpeningTime());
    }
}

